/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.query;

import java.io.IOException;

/**
 * A listener for query answers (a set of bound variables).
 **/
public interface QueryAnswerListener {

	/**
	 * Reports a query answer to the listener.
	 *
	 * @param qa The query answer.
	 * @return A flag indicating whether the query engine should continue
	 * evaluating the (sub-)query.
	 **/
	public boolean queryAnswer(QueryAnswer qa)
		throws IOException;
	
	/**
	 * Method called when the query engine has finished or aborted the query
	 * evaluation, signaling that the listener can/should clear any recorded
	 * and query-specific information.
	 **/
	public void clear();
}
