/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.query;

import org.openrdf.model.Value;

public class QueryAnswer {

/*----------+
| Variables |
+----------*/

	private Value[] _values;

/*-------------+
| Constructors |
+-------------*/

	/**
	 * Creates a new QueryAnswer.
	 **/
	public QueryAnswer(Value[] values) {
		_values = values;
	}

/*--------+
| Methods |
+--------*/

	public int getValueCount() {
		return _values.length;
	}

	public Value getValue(int idx) {
		return _values[idx];
	}

	// Overrides Object.equals(Object)
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}

		if (!(other instanceof QueryAnswer)) {
			return false;
		}

		Value[] otherValues = ((QueryAnswer)other)._values;

		if (_values.length != otherValues.length) {
			return false;
		}

		// Result is 'true' until a value has been found that is not equal
		boolean result = true;

		for (int i = 0; result && i < _values.length; i++) {
			if (_values[i] == null) {
				result = (otherValues[i] == null);
			}
			else {
				result = _values[i].equals(otherValues[i]);
			}
		}

		return result;
	}

	// Overrides Object.hashCode()
	public int hashCode() {
		int hashCode = 0;

		for (int i = 0; i < _values.length; i++) {
			Value value = _values[i];

			if (value == null) {
				// Default value for null is 0xFFFFFFFF.
				hashCode ^= (0xFFFFFFFF << i);
			}
			else {
				hashCode ^= (value.hashCode() >> i);
			}
		}

		return hashCode;
	}
}
