/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.query;

import java.util.Collection;

import org.openrdf.sesame.sail.RdfSource;

/**
 * The interface for queries.
 *
 * @author Arjan Kleine
 * @author Jeen Broekstra
 * @author Arjohn Kampman
 */
public interface Query {
	
	/**
	 * Gets the headers for the results table that is produced by this query.
	 *
	 * @return An array containing as much strings as there are values in each
	 * query result.
	 **/
	public String[] getColumnHeaders();

	/**
	 * Gets all variables that are used in this query.
	 *
	 * @param variables A Collection to add the Var objects to.
	 **/
	public void getVariables(Collection variables);
	
	/**
	 * Evaluates the query on the data contained in the supplied RdfSource and
	 * reports the results to the supplied QueryAnswerListener.
	 *
	 * @param rdfSource An RdfSource containing the data to evaluate the query on.
	 * @param listener A QueryAnswerListener that will receive any query results.
	 * @exception SailQueryException An exception indicating that the query
	 * evaluation was stopped abnormally.
	 **/
	public void evaluate(RdfSource rdfSource, QueryAnswerListener listener)
		throws SailQueryException;
}
