/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.query;

import java.util.Collection;

import org.openrdf.sesame.sail.RdfSource;

/**
 * A path expression that matches specific paths in an (RDF) graph.
 *
 * @author Arjohn Kampman
 */
public interface PathExpression {

	/**
	 * Initializes the PathExpression. After a call to this method, the path
	 * expression should be able to select all matching path expressions when
	 * <tt>selectNext</tt> is called.
	 **/
	public void initialize(RdfSource rdfSource)
		throws SailQueryException;

	/**
	 * Selects the next path matching this path expression. Any variables in
	 * this path expression should be instantiated after a successful call to
	 * this method. When no more matching paths could be found, any bound
	 * variables should be uninstantiated.
	 *
	 * @return <tt>true</tt> if a next path has been found, <tt>false</tt> if
	 * no more paths could be found.
	 **/
	public boolean selectNext(RdfSource rdfSource)
		throws SailQueryException;

	/**
	 * Clears any state information in this path expression. After a call to
	 * this method, calls to <tt>selectNext</tt> should not yield any new
	 * results.
	 **/
	public void clear();

	/**
	 * Gets all variables that are used in this PathExpression.
	 *
	 * @param variables A Collection to add the Var objects to.
	 **/
	public void getVariables(Collection variables);
}
