/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.sail.query;

import java.util.Collection;

import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;

/**
 * @author Jeen Broekstra
 */
public class LocalName implements ValueExpr {

	private Var _var;
	private ValueFactory _factory;
	
	public LocalName(Var var) {
		_var = var;
		_factory = new ValueFactoryImpl();
	}
	
	public Var getVar() {
		return _var;
	}

	// Implements ValueExpr.getValue()
	public Value getValue() {
		String stringVal = getString();

		if (stringVal != null) {
			return _factory.createLiteral(stringVal);
		}

		return null;
	}

	// implements StringExpr.getString()
	public String getString() {
		Value varValue = _var.getValue();
		
		if (varValue instanceof URI) {
			return ((URI)varValue).getLocalName();
		}

		return null;
	}

	//implements StringExpr.getVariables(Collection)
	public void getVariables(Collection variables) {
		_var.getVariables(variables);
	}

	public String toString() {
		return "localName(" + _var + ")";
	}
}
