/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.query;

import java.util.Collection;

import org.openrdf.sesame.sail.RdfSource;

/**
 * Checks whether the wrapped Query produces any results.
 */
public class Exists implements BooleanExpr {

	private Query _qc;
	
	public Exists(Query qc) {
		_qc = qc;
	}

	public Query getArg() {
		return _qc;
	}

	public void getVariables(Collection variables) {
		_qc.getVariables(variables);
	}

	public boolean isTrue(RdfSource rdfSource)
		throws SailQueryException
	{
		ExistsTester existsTester = new ExistsTester();

		_qc.evaluate(rdfSource, existsTester);

		return existsTester.queryHasResults();
	}

	public String toString() {
		return "EXISTS(" + _qc.toString() + ")";
	}

/*-------------------------+
| Inner class ExistsTester |
+-------------------------*/

	private static class ExistsTester implements QueryAnswerListener {

		private boolean _queryHasResults = false;

		// implements QueryAnswerListener.queryAnswer(QueryAnswer)
		public boolean queryAnswer(QueryAnswer qa) {
			_queryHasResults = true;
			return false;
		}

		// implements QueryAnswerListener.clear()
		public void clear() {
			_queryHasResults = false;
		}

		public boolean queryHasResults() {
			return _queryHasResults;
		}
	}
}
