/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.query;

import java.util.Collection;

import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;

import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.util.EmptyStatementIterator;

/**
 * @author Arjohn Kampman
 */
public class DirectSubClassOf extends TriplePattern {

/*----------+
| Constants |
+----------*/

	private static final Var PREDICATE_VAR =
			new Var("_directSubClassOf", URIImpl.RDFS_SUBCLASSOF);

/*-------------+
| Constructors |
+-------------*/

	public DirectSubClassOf(Var subjectVar, Var objectVar) {
		super(subjectVar, PREDICATE_VAR, objectVar);
	}

/*--------+
| Methods |
+--------*/

	// Overrides TriplePattern._getStatementIterator(...)
	protected StatementIterator _getStatementIterator(
		RdfSource rdfSource, Resource subj, URI pred, Value obj)
		throws SailQueryException
	{
		try {
			RdfSchemaSource rss = (RdfSchemaSource)rdfSource;

			if (obj == null || obj instanceof Resource) {
				return rss.getDirectSubClassOf(subj, (Resource)obj);
			}

			// object is not a Resource, possibly due to a
			// wrong comparison in the where clause
			return new EmptyStatementIterator();
		}
		catch (ClassCastException e) {
			// repository is not schema-enabled
			throw new SailQueryException("Cannot evaluate directSubClassOf on a non-inferencing repository");
		}
	}

	// Overrides TriplePattern.getVariables(...)
	public void getVariables(Collection variables) {
		variables.add( getSubjectVar() );
		variables.add( getObjectVar() );
	}

	public String toString() {
		StringBuffer result = new StringBuffer(128);

		result.append("(");

		if (getSubjectVar().hasValue()) {
			result.append(getSubjectVar().getString());
		}
		else {
			result.append(getSubjectVar().toString());
		}

		result.append(",");

		result.append("serql:directSubClassOf");

		result.append(",");

		if (getObjectVar().hasValue()) {
			result.append(getObjectVar().getString());
		}
		else {
			result.append(getObjectVar().toString());
		}

		result.append(")");

		return result.toString();
	}
}
