/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.query;

import java.util.Collection;

import org.openrdf.sesame.sail.RdfSource;

/**
 */
public class CompareAll implements BooleanExpr {

/*----------+
| Variables |
+----------*/

	private ValueExpr _valueExpr;
	private Query _qc;
	private int _operator;

/*-------------+
| Constructors |
+-------------*/

	public CompareAll(ValueExpr valueExpr, Query qc, int op) {
		_valueExpr = valueExpr;
		_qc = qc;
		_operator = op;
	}

/*--------+
| Methods |
+--------*/

	public ValueExpr getLeftArg() {
		return _valueExpr;
	}

	public Query getRightArg() {
		return _qc;
	}

	public int getOperator() {
		return _operator;
	}

	public void getVariables(Collection variables) {
		_valueExpr.getVariables(variables);
		_qc.getVariables(variables);
	}

	public boolean isTrue(RdfSource rdfSource)
		throws SailQueryException
	{
		ValueListCompare vlc = new ValueListCompare();

		_qc.evaluate(rdfSource, vlc);

		return vlc.isTrue();
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(128);
		buf.append(_valueExpr.toString());
		buf.append(' ');
		buf.append( ValueCompare.operator2string(_operator) );
		buf.append(" ALL ");
		buf.append( _qc.toString() );

		return buf.toString();
	}

/*-----------------------------+
| Inner class ValueListCompare |
+-----------------------------*/

	private class ValueListCompare implements QueryAnswerListener {

		private boolean _isTrue = true;

		// implements QueryAnswerListener.queryAnswer(QueryAnswer)
		public boolean queryAnswer(QueryAnswer qa) {
			try {
				_isTrue = ValueCompare.isTrue(_valueExpr.getValue(), qa.getValue(0), _operator);
			}
			catch (BooleanExprEvaluationException e) {
				_isTrue = false;
			}

			// Continue evaluation until a mismatch has been found
			return _isTrue;
		}

		// implements QueryAnswerListener.clear()
		public void clear() {
			_isTrue = true;
		}

		public boolean isTrue() {
			return _isTrue;
		}
	}
}
