/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.query;

import java.util.Collection;

import org.openrdf.sesame.sail.RdfSource;

/**
 * An expressions that can evaluate to the boolean values <tt>true</tt>
 * and <tt>false</tt>.
 **/
public interface BooleanExpr {

	/**
	 * Evaluates the boolean expression on the supplied RdfSource object.
	 *
	 * @param rdfSource The RdfSource to evaluate the boolean expression against.
	 * @return the result of the evaluation.
	 * @exception BooleanExprEvaluationException If the boolean expression could
	 * not be evaluated, for example when comparing two incompatible operands.
	 * When thrown, the result of the boolean expression is neither
	 * <tt>true</tt> or <tt>false</tt>, but unknown.
	 **/
	public boolean isTrue(RdfSource rdfSource)
		throws BooleanExprEvaluationException, SailQueryException;

	/**
	 * Gets all variables that are used in this BooleanExpr.
	 * @param variables A Collection to add the Var objects to.
	 **/
	public void getVariables(Collection variables);
}
