/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail.query;

import java.util.Collection;

import org.openrdf.sesame.sail.RdfSource;

/**
 **/
public class And implements BooleanExpr {

	protected BooleanExpr _leftArg;
	protected BooleanExpr _rightArg;

	public And(BooleanExpr leftArg, BooleanExpr rightArg) {
		_leftArg = leftArg;
		_rightArg = rightArg;
	}

	public boolean isTrue(RdfSource rdfSource)
		throws BooleanExprEvaluationException, SailQueryException
	{
		try {
			if (!_leftArg.isTrue(rdfSource)) {
				// Left argument evaluates to false, we don't need to look any further
				return false;
			}
		}
		catch (BooleanExprEvaluationException e) {
			// Failed to evaluate the left argument. Result is 'false' when
			// the right argument evaluates to 'false', failure otherwise.
			if (!_rightArg.isTrue(rdfSource)) {
				return false;
			}
			else {
				throw new BooleanExprEvaluationException();
			}
		}

		// Left argument evaluated to 'true', result is determined
		// by the evaluation of the right argument.
		return _rightArg.isTrue(rdfSource);
	}

	public BooleanExpr getLeftArg() {
		return _leftArg;
	}

	public BooleanExpr getRightArg() {
		return _rightArg;
	}

	public void getVariables(Collection variables) {
		_leftArg.getVariables(variables);
		_rightArg.getVariables(variables);
	}

	public String toString() {
		return "(" + _leftArg.toString() + " AND " + _rightArg.toString() + ")";
	}
}
