/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail;

/**
 * An interface for Sails that can be stacked on top of other Sails. Examples
 * of such Sail are classes that handle synchronization, or classes that
 * cache specific information (e.g. schema information).
 *
 * @author Arjohn Kampman
 * @version $Revision: 1.3.4.2 $
 */
public interface StackedSail extends Sail {

	/**
	 * Sets the base Sail that this Sail will work on top of. This method
	 * will be called before the initialize() method is called.
	 **/
	public void setBaseSail(Sail baseSail);

	/**
	 * Gets the base Sail that this Sail works on top of.
	 **/
	public Sail getBaseSail();
}
