/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail;

/**
 * An iterator over namespaces that are stored in RDF Sails.
 *
 * @author Arjohn Kampman
 * @version $Revision: 1.3.4.2 $
 */
public interface NamespaceIterator {

	/**
	 * Checks whether there are any more namespaces available.
	 *
	 * @return true if there are more namespaces available, false otherwise.
	 */
	public boolean hasNext();

	/**
	 * Go to the next namespace.
	 * @exception java.util.NoSuchElementException If the iterator has no more
	 * results
	 */
	public void next();

	/**
	 * Gets the name of the current namespace (i.e. it's URI).
	 *
	 * @return name of namespace
	 */
	public String getName();

	/**
	 * Gets the prefix of the current namespace.
	 *
	 * @return prefix of namespace
	 */
	public String getPrefix();

	/**
	 * Closes the iterator and frees any resources that it uses (e.g.
	 * connections to databases). Every NamespaceIterator should be properly
	 * closed when it has returned all of its namespaces, or when it is no
	 * longer needed.
	 */
	public void close();
}
