/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.sail;
/**
 * Object that represents a Namespace.
 *
 * @author Arjohn Kampman
 * @author Jeen Broekstra
 * @version $Revision: 1.3.4.2 $
 */
public class Namespace {

/*----------+
| Variables |
+----------*/
	/** Prefix of namespace*/
	protected String _prefix;

	/** Name of namespace*/
	protected String _name;

/*-------------+
| Constructors |
+-------------*/

	/**
	 * Constructor.
	 *
	 * @param prefix prefix of namespace
	 * @param name name namespace
	 */	
	public Namespace(String prefix, String name) {
		_prefix = prefix;
		_name = name;
	}

/*--------+
| Methods |
+--------*/

	/**
	 * Gets the prefix of Namespace.
	 *
	 * @return prefix of Namespace
	 */
	public String getPrefix() {
		return _prefix;
	}

	/**
	 * Sets the prefix of Namespace.
	 *
	 * @param prefix The (new) prefix for this namespace.
	 */
	public void setPrefix(String prefix) {
		_prefix = prefix;
	}

	/**
	 * Gets the name of Namespace.
	 *
	 * @return name of Namespace
	 */
	public String getName() {
		return _name;
	}
	
	/**
	 * Returns a string representation of the object.
	 *
	 * @return String representation of Namespace
	 */
	public String toString() {
		return _prefix + " :: " + _name;
	}
}
