/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.repository;

import java.io.IOException;

import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.UnknownRepositoryException;

/**
 * The main interface for all Sesame services. A Sesame service
 * administers a number of Sesame repositories and allows you to
 * get an overview of all available repositories and to retrieve
 * objects representing specific repositories.
 *
 * @author Jeen Broekstra
 * @author Arjohn Kampman
 * @version $Revision: 1.7.4.2 $
 */
public interface SesameService {

	/**
	 * Gets a list of all repositories that are accessible by the
	 * currently logged in user. If no user is logged in, all repositories
	 * that are world-accessible are retrieved.
	 *
	 * @return A RepositoryListImpl
	 * @exception IOException If an I/O error occurred while fetching
	 * information about the available repositories.
	 **/
	public RepositoryList getRepositoryList()
		throws IOException;

	/**
	 * Gets a SesameRepository object for the specified repository ID.
	 *
	 * @param repositoryID A repository ID.
	 * @exception UnknownRepositoryException If the specified
	 * repository ID is unknown.
	 * @exception ConfigurationException If the requested repository
	 * was not configured properly.
	 **/
	public SesameRepository getRepository(String repositoryID)
		throws UnknownRepositoryException, ConfigurationException, IOException;

	/**
	 * Log in to a Sesame service.
	 *
	 * @exception AccessDeniedException If the attempt to log in failed.
	 * @exception IOException If an I/O error occurred.
	 * @exception IllegalArgumentException If the supplied username is
	 * not a legal username.
	 **/
	public void login(String username, String password)
		throws AccessDeniedException, IOException;

	/**
	 * Log out from a Sesame service.
	 *
	 * @exception IOException If an I/O error occurred.
	 **/
	public void logout()
		throws IOException;
}
