/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.repository;

import java.util.List;

import org.openrdf.sesame.config.RepositoryInfo;

/**
 * A list for repository information. This list is provided for those who
 * do not want to use the streaming approach provided by the
 * RepositoryListListener. The <tt>RepositoryListBuilder</tt> can be used to
 * build the lists.
 *
 * @see org.openrdf.sesame.config.RepositoryListImpl
 **/
public interface RepositoryList {


	/**
	 * Gets the number of repositories in this list.
	 **/
	public int getRepositoryCount();

	/**
	 * Gets a list of RepositoryInfo objects containing info about all
	 * available repositories.
	 *
	 * @return A List of RepositoryInfo objects.
	 * @see RepositoryInfo
	 **/
	public List getRepositories();

	/**
	 * Gets a list of the repositories that are marked as being readable.
	 *
	 * @return A List of RepositoryInfo objects.
	 * @see RepositoryInfo
	 **/
	public List getReadableRepositories();

	/**
	 * Gets a list of the repositories that are marked as being writable.
	 *
	 * @return A List of RepositoryInfo objects.
	 * @see RepositoryInfo
	 **/
	public List getWritableRepositories();

	/**
	 * Gets a list of the repositories that are marked as being both readable
	 * and writable.
	 *
	 * @return A List of RepositoryInfo objects.
	 * @see RepositoryInfo
	 **/
	public List getReadWriteRepositories();
	/**
	 * Gets the information about the repository with the specified ID.
	 *
	 * @return A RepositoryInfo object describing the requested repository,
	 * or null if no such repository is in this list.
	 **/
	public RepositoryInfo getRepository(String repositoryId);

	/**
	 * Adds info about a repository to this list.
	 *
	 * @param id The repository's ID.
	 * @param title The repository's title.
	 * @param readable Flag indicating whether the repository is
	 * readable.
	 * @param writeable Flag indicating whether the repository is
	 * writeable.
	 **/
	public void addRepository(
		String id, String title, boolean readable, boolean writeable);

	/**
	 * Adds info about a repository to this list.
	 *
	 * @param repInfo A RepositoryInfo object.
	 **/
	public void addRepository(RepositoryInfo repInfo);
}
