/* Generated By:JavaCC: Do not edit this line. SerqlParser.java */
package org.openrdf.sesame.query.serql.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.openrdf.util.xml.XmlDatatypeUtil;
import org.openrdf.vocabulary.OWL;
import org.openrdf.vocabulary.RDF;
import org.openrdf.vocabulary.RDFS;
import org.openrdf.vocabulary.XmlSchema;

import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;

import org.openrdf.rio.ntriples.NTriplesUtil;

import org.openrdf.sesame.query.GraphQuery;
import org.openrdf.sesame.query.TableQuery;
import org.openrdf.sesame.sail.query.And;
import org.openrdf.sesame.sail.query.BooleanConstant;
import org.openrdf.sesame.sail.query.BooleanExpr;
import org.openrdf.sesame.sail.query.ConstructQuery;
import org.openrdf.sesame.sail.query.CompareAll;
import org.openrdf.sesame.sail.query.CompareAny;
import org.openrdf.sesame.sail.query.Datatype;
import org.openrdf.sesame.sail.query.Exists;
import org.openrdf.sesame.sail.query.GraphPattern;
import org.openrdf.sesame.sail.query.In;
import org.openrdf.sesame.sail.query.Intersect;
import org.openrdf.sesame.sail.query.IsBNode;
import org.openrdf.sesame.sail.query.IsLiteral;
import org.openrdf.sesame.sail.query.IsResource;
import org.openrdf.sesame.sail.query.IsURI;
import org.openrdf.sesame.sail.query.Label;
import org.openrdf.sesame.sail.query.Lang;
import org.openrdf.sesame.sail.query.Like;
import org.openrdf.sesame.sail.query.LiteralExpr;
import org.openrdf.sesame.sail.query.LocalName;
import org.openrdf.sesame.sail.query.Minus;
import org.openrdf.sesame.sail.query.Namespace;
import org.openrdf.sesame.sail.query.Not;
import org.openrdf.sesame.sail.query.Null;
import org.openrdf.sesame.sail.query.Or;
import org.openrdf.sesame.sail.query.ProjectionElem;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.ResourceExpr;
import org.openrdf.sesame.sail.query.SelectQuery;
import org.openrdf.sesame.sail.query.StringConstant;
import org.openrdf.sesame.sail.query.Union;
import org.openrdf.sesame.sail.query.ValueCompare;
import org.openrdf.sesame.sail.query.ValueExpr;
import org.openrdf.sesame.sail.query.Var;

public class SerqlParser implements SerqlParserConstants {

/*-------------------------------+
| Constants                      |
+-------------------------------*/

        public static final String SERQL_NS = "http://www.openrdf.org/schema/serql#";

        public static final URI SERQL_DIRECTSUBCLASSOF    = new URIImpl(SERQL_NS + "directSubClassOf");
        public static final URI SERQL_DIRECTSUBPROPERTYOF = new URIImpl(SERQL_NS + "directSubPropertyOf");
        public static final URI SERQL_DIRECTTYPE          = new URIImpl(SERQL_NS + "directType");

        public static final URI XSD_INTEGER = new URIImpl(XmlSchema.INTEGER);
        public static final URI XSD_DECIMAL = new URIImpl(XmlSchema.DECIMAL);

        static final Var RDF_TYPE_VAR      = new Var("_rdfType", URIImpl.RDF_TYPE);
        static final Var RDF_STATEMENT_VAR = new Var("_rdfStatement", URIImpl.RDF_STATEMENT);
        static final Var RDF_SUBJECT_VAR   = new Var("_rdfSubject", URIImpl.RDF_SUBJECT);
        static final Var RDF_PREDICATE_VAR = new Var("_rdfPredicate", URIImpl.RDF_PREDICATE);
        static final Var RDF_OBJECT_VAR    = new Var("_rdfObject", URIImpl.RDF_OBJECT);

/*-------------------------------+
| Variables                      |
+-------------------------------*/

        /**
	 * Mapping of prefix to namespace.
	 **/
        protected Map _namespaces = new HashMap(16);

        /**
	 * List of shared variables. Named variables are shared; multiple
	 * occurrences of the name of one variable in a query represent
	 * the same variable.
	 **/
        protected List _sharedVars = new ArrayList(16);

        /**
	 * List of shared variables that have not been bound. All newly created
	 * shared variables are first inserted in this list, and are removed
	 * again when they are bound. After parsing the query, this list should
	 * be empty.
	 **/
        protected List _unboundVars = new ArrayList(16);

        protected VarTreeNode _currentTreeNode = new VarTreeNode();

        /**
	 * Anonymous variable identifier.
	 **/
        protected int _varNo = 0;

/*-------------------------------+
| Methods                        |
+-------------------------------*/


        static class VarTreeNode {

                private VarTreeNode _parent;
                private List _variables;

                private List _children;

                public VarTreeNode() {
                        _variables = new ArrayList(8);
                        _children = new ArrayList(4);
                }

                public void addVariable(Var var) {
                        _variables.add(var);
                }

                public void addChild(VarTreeNode child) {
                        _children.add(child);
                        child.setParent(this);
                }

                public void setParent(VarTreeNode parent) {
                        _parent = parent;
                }

                public List getVariables() {
                        return _variables;
                }

                public boolean containsVar(Var var) {
                        return _variables.contains(var);
                }

                public List getChildren() {
                        return _children;
                }

                public VarTreeNode getParent() {
                        return _parent;
                }

                public boolean isRoot() {
                        return _parent == null;
                }

                public String toString() {

                        StringBuffer result = new StringBuffer(32);

                        result.append("(");

                        for (int i = 0; i < _variables.size(); i++) {
                                Var var = (Var)_variables.get(i);

                                result.append(var.getName());
                                result.append(" ");
                        }
                        result.append(")");

                        return result.toString();
                }


                /*
		 * Returns a list of variables that this node shares with its
		 * sibling nodes. The list is empty if the node does not share any
		 * vars with its siblings.
		 */
                public List getSharedWithSiblings() {
                        if (isRoot()) {
                                // by definition, the root node has no siblings.
                                return new ArrayList(0);
                        }

                        List allVars = new ArrayList(_variables);

                        List siblings = _parent.getChildren();
                        int siblingCount = siblings.size();

                        for (int i = 0; i < siblingCount; i++) {
                                VarTreeNode sibling = (VarTreeNode)siblings.get(i);

                                if (! this.equals(sibling)) {
                                        allVars.addAll(sibling.getVariables());
                                }
                        }

                        List result = new ArrayList();

                        int varCount = allVars.size();

                        for (int i = 0; i < varCount; i++) {
                                Var var = (Var)allVars.get(i);
                                int occurrences = 0;
                                for (int j = 0; j < siblingCount; j++) {
                                        VarTreeNode sibling = (VarTreeNode)siblings.get(j);
                                        if (sibling.containsVar(var)) {
                                                occurrences++;
                                        }
                                }
                                if (occurrences > 1) {
                                        result.add(var);
                                }
                        }
                        return result;
                }
        }

        protected void _checkUnboundVars()
                throws ParseException
        {
                if (!_unboundVars.isEmpty()) {
                        String msg = "Unbound variable(s): ";

                        for (int i = 0; i < _unboundVars.size(); i++) {
                                Var var = (Var)_unboundVars.get(i);
                                if (i > 0) {
                                        msg += ", ";
                                }
                                msg += var.getName();
                        }

                        throw new ParseException(msg);
                }
        }

        protected void _checkVariableScoping()
                throws ParseException
        {
                while (!_currentTreeNode.isRoot()) {
                        _currentTreeNode = _currentTreeNode.getParent();
                }

                // enter the recursion with the tree root as current node.
                _checkVariableScoping(_currentTreeNode);
        }

        protected void _checkVariableScoping(VarTreeNode current)
                throws ParseException
        {
                List children = current.getChildren();

                if (children.size() > 0) {
                        for (int i = 0; i < children.size(); i++) {
                                VarTreeNode child = (VarTreeNode)children.get(i);
                                _checkVariableScoping(child);
                        }
                }
                else { // leaf node
                        VarTreeNode parent = current.getParent();
                        if (parent != null) {
                                List sharedVars = current.getSharedWithSiblings();
                                int sharedCount = sharedVars.size();

                                for (int i = 0; i < sharedCount; i++) {
                                        Var sharedVar = (Var)sharedVars.get(i);
                                        if (! parent.containsVar(sharedVar)) {
                                                throw new ParseException("Shared variable " + sharedVar.getName() + " not bound in parent path expression.");
                                        }
                                }
                        }
                }
        }


        /**
	 * Adds a mapping from the specified prefix to the specified
	 * namespace. The specified prefix must already be mapped to some
	 * (other) namespace.
	 *
	 * @return true if the mapping has been added, false otherwise.
	 * @exception ParseException If the specified prefix is already
	 * mapped to some (other) namespace.
	 **/
        protected void _setNamespacePrefix(String prefix, String namespace)
                throws ParseException
        {
                if (_namespaces.containsKey(prefix)) {
                        // Prefix already defined, report this error.
                        throw new ParseException("Prefix \"" + prefix + "\" already in use.");
                }

                _namespaces.put(prefix, namespace);
        }

        /**
	 * Gets the namespace that is mapped to the supplied prefix.
	 **/
        protected String _getNamespace(String prefix) {
                String result = (String)_namespaces.get(prefix);

                // rdf, rdfs, xsd, owl and serql are default
                // namespace when not defined explicitly.
                if (result == null) {
                        if ("rdf".equals(prefix)) {
                                result = RDF.NAMESPACE;
                        }
                        else if ("rdfs".equals(prefix)) {
                                result = RDFS.NAMESPACE;
                        }
                        else if ("xsd".equals(prefix)) {
                                result = XmlSchema.NAMESPACE;
                        }
                        else if ("owl".equals(prefix)) {
                                result = OWL.NAMESPACE;
                        }
                        else if ("serql".equals(prefix)) {
                                result = SERQL_NS;
                        }
                }
                return result;
        }

        /**
	 * Returns the shared instance of Var that is associated with the
	 * specified variable name. A new shared variable will be created
	 * whenever this method is called with a new variable name.
	 **/
        protected Var _getSharedVar(String varName) {
                Var var;

                // Search for a variable with the supplied name in _sharedVars
                Iterator i = _sharedVars.iterator();
                while (i.hasNext()) {
                        var = (Var)i.next();
                        if (var.getName().equals(varName)) {
                                // Variable found
                                _currentTreeNode.addVariable(var);
                                return var;
                        }
                }

                // Variable does not exist; create one and add it to a number of lists
                var = new Var(varName);
                _sharedVars.add(var);
                _unboundVars.add(var);
                _currentTreeNode.addVariable(var);

                return var;
        }

        /**
	 * Creates a new anonymous variable and returns it.
	 **/
        protected Var _createAnonymousVar() {
                Var result = new Var("_" + _varNo++);
                result.setAnonymous(true);
                return result;
        }

        /**
	 * Parses a string representating of full or abbreviated URI and
	 * creates a URI object from it.
	 **/
        protected URI _parseURI(String uri)
                throws ParseException
        {
                if (uri.startsWith("<")) {
                        return _parseFullURI(uri);
                }
                else {
                        return _parseQName(uri);
                }
        }

        /**
	 * Parses a string representing a full URI (i.e.
	 * <tt>&lt;http://foo/bar&gt;</tt>) and creates a URI
	 * object for it.
	 **/
        protected URI _parseFullURI(String uri)
                throws ParseException
        {
                // Full URI starts with "<" and ends with ">", remove these characters.
                return new URIImpl( uri.substring(1, uri.length() - 1) );
        }

        /**
	 * Parses a string representing an abbreviated URI (i.e.
	 * <tt>rdf:type</tt>) and creates a URI object for it.
	 **/
        protected URI _parseQName(String uri)
                throws ParseException
        {
                // QNames have the form PREFIX:LNAME, substitute the PREFIX
                // with an actual namespace.

                int colonIdx = uri.indexOf(":");

                String prefix = uri.substring(0, colonIdx);
                String localName = uri.substring(colonIdx + 1);

                String namespace = _getNamespace(prefix);

                if (namespace == null) {
                        throw new ParseException("Prefix \"" + prefix + "\" not defined.");
                }

                return new URIImpl(namespace + localName);
        }

        /**
	 * Parses a string representing a blank node URI (i.e. <tt>_:node1</tt>) and
	 * creates a BNode object for it.
	 **/
        protected BNode _parseBNode(String bnode)
                throws ParseException
        {
                return new BNodeImpl( bnode.substring(2) );
        }

        /**
	 * Parses a new Literal from the supplied String.
	 **/
        protected Literal _parseLiteral(String literal)
                throws ParseException
        {
                // Find string separation points
                int endLabelIdx = _findEndOfLabel(literal);
                int startLangIdx = literal.indexOf("@", endLabelIdx);
                int startDtIdx = literal.indexOf("^^", Math.max(endLabelIdx, startLangIdx));

                // Get label
                String label = literal.substring(1, endLabelIdx);
                label = NTriplesUtil.unescapeString(label);

                if (startLangIdx != -1) {
                        // Get language
                        String language = literal.substring(startLangIdx + 1);
                        return new LiteralImpl(label, language);
                }
                else if (startDtIdx != -1) {
                        // Get datatype
                        String dtString = literal.substring(startDtIdx + 2);
                        URI datatype = _parseURI(dtString);

                        // Normalize label when datatype is XML Schema built-in
                        if (XmlDatatypeUtil.isBuiltInDatatype(datatype.getURI())) {
                                try {
                                        label = XmlDatatypeUtil.normalize(label, datatype.getURI());
                                }
                                catch (IllegalArgumentException e) {
                                        throw new ParseException(e.getMessage());
                                }
                        }

                        return new LiteralImpl(label, datatype);
                }
                else {
                        return new LiteralImpl(label);
                }
        }

        /**
	 * Finds the end of the label in a literal string. This method
	 * takes into account that characters can be escaped using
	 * backslashes.
	 *
	 * @return The index of the double quote ending the label.
	 **/
        private int _findEndOfLabel(String literal)
                throws ParseException
        {
                // First character of literal is guaranteed to be a double
                // quote, start search at second character.

                boolean previousWasBackslash = false;

                for (int i = 1; i < literal.length(); i++) {
                        char c = literal.charAt(i);

                        if (c == '"' && !previousWasBackslash) {
                                return i;
                        }
                        else if (c == '\\' && !previousWasBackslash) {
                                // start of escape
                                previousWasBackslash = true;
                        }
                        else if (previousWasBackslash) {
                                // c was escaped
                                previousWasBackslash = false;
                        }
                }

                throw new ParseException("Could not find end of literal label");
        }

        /**
	 * Creates a new ParseException with the supplied current and
	 * expected tokens. See ParseException for details.
	 **/
        protected ParseException _createParseException(
                Token currentTokenVal, String[] tokenImage)
        {
                // Append "<EOF>" in front of the supplied String array.
                // ParseException.getMessage expects "<EOF>" as the first String
                // in the String array.
                int length = tokenImage.length;

                // New String array has one element extra, therefore length of
                // new String array is increased by one.
                String[] newTokenImage = new String[length + 1];

                // First element is "<EOF>"
                newTokenImage[0] = "<EOF>";

                // Copy Strings of the supplied String array to the new String array.
                for (int i = 0; i < length; i++) {
                        newTokenImage[i +1] = tokenImage[i];
                }

                int[][] expectedTokenSequences = new int[1][length];

                for (int i = 0; i < length; i++) {
                        expectedTokenSequences [0][i] = i +1;
                }

                return new ParseException(currentTokenVal, expectedTokenSequences, newTokenImage);
        }

  final public TableQuery parseTableQuery() throws ParseException {
        Query qc;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USING:
      namespace_list();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    qc = table_query_set();
    jj_consume_token(0);
                        // Check for unbound variables.
                        _checkUnboundVars();

                        // Check the variable scope tree for shared variables
                        // in children that are not present in the parent.
                        _checkVariableScoping();

                        {if (true) return new TableQuery(qc);}
    throw new Error("Missing return statement in function");
  }

  final public Query table_query_set() throws ParseException {
        Query result = null;
        Query rightArg = null;
        boolean all = false;
    result = table_query();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNION:
    case MINUS:
    case INTERSECT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNION:
        jj_consume_token(UNION);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
                                  all = true;
          break;
        default:
          jj_la1[1] = jj_gen;
          ;
        }
        rightArg = table_query_set();
                                result = new Union(result, rightArg, all);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        rightArg = table_query_set();
                                result = new Minus(result, rightArg, all);
        break;
      case INTERSECT:
        jj_consume_token(INTERSECT);
        rightArg = table_query_set();
                                result = new Intersect(result, rightArg, all);
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
                        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public Query table_query() throws ParseException {
        Query qc;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      qc = table_query_set();
      jj_consume_token(RPAREN);
                                                   {if (true) return qc;}
      break;
    case SELECT:
      qc = select_query();
                              {if (true) return qc;}
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public GraphQuery parseGraphQuery() throws ParseException {
        Query qc;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USING:
      namespace_list();
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    qc = graph_query_set();
    jj_consume_token(0);
                        // Check for unbound variables.
                        _checkUnboundVars();

                        // Check the variable scope tree for shared variables
                        // in children that are not present in the parent.
                        _checkVariableScoping();

                        {if (true) return new GraphQuery(qc, new HashMap(_namespaces));}
    throw new Error("Missing return statement in function");
  }

  final public Query graph_query_set() throws ParseException {
        Query result = null;
        Query rightArg = null;
        boolean all = false;
    result = graph_query();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNION:
    case MINUS:
    case INTERSECT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNION:
        jj_consume_token(UNION);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALL:
          jj_consume_token(ALL);
                                  all = true;
          break;
        default:
          jj_la1[6] = jj_gen;
          ;
        }
        rightArg = graph_query_set();
                                result = new Union(result, rightArg, all);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        rightArg = graph_query_set();
                                result = new Minus(result, rightArg, all);
        break;
      case INTERSECT:
        jj_consume_token(INTERSECT);
        rightArg = graph_query_set();
                                result = new Intersect(result, rightArg, all);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
                        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public Query graph_query() throws ParseException {
        Query qc;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      qc = graph_query_set();
      jj_consume_token(RPAREN);
                                                   {if (true) return qc;}
      break;
    case CONSTRUCT:
      qc = construct_query();
                                 {if (true) return qc;}
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*-------------------------------+
| NAMESPACE DECLARATIONS         |
+-------------------------------*/
  final public void namespace_list() throws ParseException {
    jj_consume_token(USING);
    jj_consume_token(NAMESPACE);
    namespace();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_1;
      }
      jj_consume_token(COMMA);
      namespace();
    }
  }

  final public void namespace() throws ParseException {
        Token prefixToken;
        ResourceExpr uri;
    prefixToken = jj_consume_token(PREFIX_NAME);
    jj_consume_token(EQ);
    uri = full_uri();
                        String prefix = prefixToken.image;
                        _setNamespacePrefix(prefix, uri.getString());
  }

  final public Query select_query() throws ParseException {
        boolean distinct = false;
        List projection;
        GraphPattern graphPattern = new GraphPattern();
        boolean hasLimit = false, hasOffset = false;
        int limit = -1, offset = -1;
    jj_consume_token(SELECT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DISTINCT:
      jj_consume_token(DISTINCT);
                       distinct = true;
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    projection = projection();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      graph_pattern(graphPattern);
      break;
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIMIT:
      jj_consume_token(LIMIT);
      limit = pos_integer();
                                          hasLimit = true;
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OFFSET:
      jj_consume_token(OFFSET);
      offset = pos_integer();
                                            hasOffset = true;
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
                        if (projection == null) {
                                // "SELECT *", take all shared variables from the graph pattern
                                Set gpVariables = new HashSet();
                                graphPattern.getVariables(gpVariables);

                                List projVars = new ArrayList(_sharedVars);
                                projVars.retainAll(gpVariables);

                                projection = new ArrayList(projVars.size());

                                // Create ProjectionElem objects for all gathered variables
                                for (int i = 0; i < projVars.size(); i++) {
                                        Var var = (Var)projVars.get(i);
                                        projection.add( new ProjectionElem(var) );
                                }
                        }

                        if (projection.isEmpty()) {
                                {if (true) throw new ParseException("Select clause does not contain any variables.");}
                        }

                        SelectQuery result = new SelectQuery(distinct, projection, graphPattern);

                        if (hasLimit) {
                                result.setLimit(limit);
                        }

                        if (hasOffset) {
                                result.setOffset(offset);
                        }

                        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public Query construct_query() throws ParseException {
        boolean distinct = false;
        GraphPattern constructExpressions = null;
        GraphPattern graphPattern = new GraphPattern();
        boolean hasLimit = false, hasOffset = false;
        int limit = -1, offset = -1;
    jj_consume_token(CONSTRUCT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DISTINCT:
      jj_consume_token(DISTINCT);
                       distinct = true;
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
      break;
    case LBRACE:
    case LBRACK:
                  constructExpressions = new GraphPattern();
      path_expr_list(constructExpressions);
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FROM:
      jj_consume_token(FROM);
      graph_pattern(graphPattern);
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LIMIT:
      jj_consume_token(LIMIT);
      limit = pos_integer();
                                          hasLimit = true;
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OFFSET:
      jj_consume_token(OFFSET);
      offset = pos_integer();
                                            hasOffset = true;
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
                        // Check if '*' was used in the construct clause
                        if (constructExpressions == null) {
                                constructExpressions = graphPattern;
                        }

                        // List of TriplePattern objects
                        List constructList = new ArrayList(constructExpressions.getPathExpressionsRecursively());

                        ConstructQuery result = new ConstructQuery(distinct, constructList, graphPattern);

                        if (hasLimit) {
                                result.setLimit(limit);
                        }

                        if (hasOffset) {
                                result.setOffset(offset);
                        }

                        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public List projection() throws ParseException {
        ProjectionElem projElem;
        List projection = new ArrayList(16);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
                 {if (true) return null;}
      break;
    case UNDERSCORE:
    case NAMESPACE:
    case LABEL:
    case LANG:
    case DATATYPE:
    case LOCALNAME:
    case NULL:
    case LITERAL:
    case FULL_URI:
    case BNODE:
    case QNAME:
    case PREFIX_NAME:
    case POS_INTEGER:
    case NEG_INTEGER:
    case DECIMAL:
      projElem = projection_elem();
                                        projection.add(projElem);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_2;
        }
        jj_consume_token(COMMA);
        projElem = projection_elem();
                                                        projection.add(projElem);
      }
                        {if (true) return projection;}
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ProjectionElem projection_elem() throws ParseException {
        ValueExpr item;
        String alias = null;
    item = var_or_value();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AS:
      jj_consume_token(AS);
      alias = string();
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
                {if (true) return new ProjectionElem(item, alias);}
    throw new Error("Missing return statement in function");
  }

  final public void graph_pattern(GraphPattern graphPattern) throws ParseException {
        BooleanExpr where;
    path_expr_list(graphPattern);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      jj_consume_token(WHERE);
      where = boolean_expr();
                        graphPattern.addConstraint(where);
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
  }

  final public void path_expr_list(GraphPattern graphPattern) throws ParseException {
    path_expr(graphPattern);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      path_expr(graphPattern);
    }
  }

  final public void path_expr(GraphPattern graphPattern) throws ParseException {
        PathElement pe;
        GraphPattern optionalGP;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      pe = path_expr_head(graphPattern);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
      case LBRACK:
      case UNDERSCORE:
      case FULL_URI:
      case QNAME:
      case PREFIX_NAME:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACK:
        case UNDERSCORE:
        case FULL_URI:
        case QNAME:
        case PREFIX_NAME:
          path_expr_tail(pe.getObjectVars(), graphPattern);
          break;
        case SEMICOLON:
          jj_consume_token(SEMICOLON);
          path_expr_tail(pe.getSubjectVars(), graphPattern);
          break;
        default:
          jj_la1[25] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[26] = jj_gen;
        ;
      }
      break;
    case LBRACK:
      jj_consume_token(LBRACK);
                        optionalGP = new GraphPattern();

                        // Create new variable scope
                        VarTreeNode node = new VarTreeNode();
                        _currentTreeNode.addChild(node);
                        _currentTreeNode = node;
      graph_pattern(optionalGP);
      jj_consume_token(RBRACK);
                        graphPattern.addOptional(optionalGP);

                        // Restore variable scope
                        _currentTreeNode = _currentTreeNode.getParent();
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public PathElement path_expr_head(GraphPattern graphPattern) throws ParseException {
        List leftNode, rightNode;
        Var edge;
    leftNode = node(graphPattern);
    edge = edge();
    rightNode = node(graphPattern);
                        PathElement pe = new PathElement(leftNode, edge, rightNode);
                        graphPattern.addAll( pe.getTriplePatterns() );
                        {if (true) return pe;}
    throw new Error("Missing return statement in function");
  }

  final public void path_expr_tail(List leftNode, GraphPattern graphPattern) throws ParseException {
        Var edge;
        List rightNode;
        PathElement pe;
        GraphPattern optionalGP;
        BooleanExpr where;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNDERSCORE:
    case FULL_URI:
    case QNAME:
    case PREFIX_NAME:
      edge = edge();
      rightNode = node(graphPattern);
                        pe = new PathElement(leftNode, edge, rightNode);
                        graphPattern.addAll( pe.getTriplePatterns() );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
      case LBRACK:
      case UNDERSCORE:
      case FULL_URI:
      case QNAME:
      case PREFIX_NAME:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACK:
        case UNDERSCORE:
        case FULL_URI:
        case QNAME:
        case PREFIX_NAME:
          path_expr_tail(rightNode, graphPattern);
          break;
        case SEMICOLON:
          jj_consume_token(SEMICOLON);
          path_expr_tail(leftNode, graphPattern);
          break;
        default:
          jj_la1[28] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[29] = jj_gen;
        ;
      }
      break;
    case LBRACK:
      jj_consume_token(LBRACK);
                        optionalGP = new GraphPattern();

                        // Create new variable scope
                        VarTreeNode node = new VarTreeNode();
                        _currentTreeNode.addChild(node);
                        _currentTreeNode = node;
      edge = edge();
      rightNode = node(optionalGP);
                        pe = new PathElement(leftNode, edge, rightNode);
                        optionalGP.addAll( pe.getTriplePatterns() );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
      case LBRACK:
      case UNDERSCORE:
      case FULL_URI:
      case QNAME:
      case PREFIX_NAME:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACK:
        case UNDERSCORE:
        case FULL_URI:
        case QNAME:
        case PREFIX_NAME:
          path_expr_tail(rightNode, optionalGP);
          break;
        case SEMICOLON:
          jj_consume_token(SEMICOLON);
          path_expr_tail(leftNode, optionalGP);
          break;
        default:
          jj_la1[30] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[31] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHERE:
        jj_consume_token(WHERE);
        where = boolean_expr();
                        optionalGP.addConstraint(where);
        break;
      default:
        jj_la1[32] = jj_gen;
        ;
      }
      jj_consume_token(RBRACK);
                        graphPattern.addOptional(optionalGP);

                        // Restore variable scope
                        _currentTreeNode = _currentTreeNode.getParent();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        path_expr_tail(leftNode, graphPattern);
        break;
      default:
        jj_la1[33] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Var edge() throws ParseException {
        Var var;
        ResourceExpr uri;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNDERSCORE:
    case PREFIX_NAME:
      var = var();
                        // Variables in edges are bound:
                        _unboundVars.remove(var);

                        {if (true) return var;}
      break;
    case FULL_URI:
    case QNAME:
      uri = uri();
                        var = _createAnonymousVar();
                        var.setValue(uri.getValue());
                        {if (true) return var;}
      break;
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// Returns a list of Var objects
  final public List node(GraphPattern graphPattern) throws ParseException {
        Var var;
        List nodeElements = new ArrayList(4);
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
    case UNDERSCORE:
    case LITERAL:
    case FULL_URI:
    case BNODE:
    case QNAME:
    case PREFIX_NAME:
    case POS_INTEGER:
    case NEG_INTEGER:
    case DECIMAL:
      var = node_elem(graphPattern);
                                                 nodeElements.add(var);
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[36] = jj_gen;
          break label_4;
        }
        jj_consume_token(COMMA);
        var = node_elem(graphPattern);
                                                                 nodeElements.add(var);
      }
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
                        // If no expressions specified, then create an anonymous variable.
                        if (nodeElements.isEmpty()) {
                                nodeElements.add( _createAnonymousVar() );
                        }

                        // Create any implicit unequalities
                        for (int i = 0; i < nodeElements.size() - 1; i++) {
                                Var var1 = (Var)nodeElements.get(i);

                                for (int j = i + 1; j < nodeElements.size(); j++) {
                                        Var var2 = (Var)nodeElements.get(j);

                                        // At least one of the variables should be unlocked
                                        // for the unequality to make any sense:
                                        if (!var1.hasValue() || !var2.hasValue()) {
                                                graphPattern.addConstraint(
                                                                new ValueCompare(var1, var2, ValueCompare.NE));
                                        }
                                }
                        }

                        {if (true) return nodeElements;}
    throw new Error("Missing return statement in function");
  }

  final public Var node_elem(GraphPattern graphPattern) throws ParseException {
        Var var;
        ValueExpr valueExpr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNDERSCORE:
    case PREFIX_NAME:
      var = var();
                        // Variables in nodes are bound:
                        _unboundVars.remove(var);

                        {if (true) return var;}
      break;
    case LITERAL:
    case FULL_URI:
    case BNODE:
    case QNAME:
    case POS_INTEGER:
    case NEG_INTEGER:
    case DECIMAL:
      valueExpr = uri_bnode_or_literal();
                        var = _createAnonymousVar();
                        var.setValue(valueExpr.getValue());
                        {if (true) return var;}
      break;
    case LBRACE:
      var = reified_stat(graphPattern);
                        {if (true) return var;}
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Var reified_stat(GraphPattern graphPattern) throws ParseException {
        List leftNode, rightNode;
        Var edge;
    leftNode = node(graphPattern);
    edge = edge();
    rightNode = node(graphPattern);
                        Var id = _createAnonymousVar();
                        ReifiedPathElement reifiedPE = new ReifiedPathElement(id, leftNode, edge, rightNode);
                        graphPattern.addAll(reifiedPE.getTriplePatterns());
                        {if (true) return id;}
    throw new Error("Missing return statement in function");
  }

  final public BooleanExpr boolean_expr() throws ParseException {
        BooleanExpr result, rightExpr;
    result = and_expr();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OR:
      jj_consume_token(OR);
      rightExpr = boolean_expr();
                                result = new Or(result, rightExpr);
      break;
    default:
      jj_la1[39] = jj_gen;
      ;
    }
                        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public BooleanExpr and_expr() throws ParseException {
        BooleanExpr result, rightExpr;
    result = boolean_elem();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AND:
      jj_consume_token(AND);
      rightExpr = and_expr();
                                result = new And(result, rightExpr);
      break;
    default:
      jj_la1[40] = jj_gen;
      ;
    }
                        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public BooleanExpr boolean_elem() throws ParseException {
        BooleanExpr expr;
        Query   qc;
        Var var;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      expr = boolean_expr();
      jj_consume_token(RPAREN);
                                                     {if (true) return expr;}
      break;
    case TRUE:
      jj_consume_token(TRUE);
                                                     {if (true) return BooleanConstant.TRUE;}
      break;
    case FALSE:
      jj_consume_token(FALSE);
                                                     {if (true) return BooleanConstant.FALSE;}
      break;
    case NOT:
      jj_consume_token(NOT);
      expr = boolean_elem();
                                                     {if (true) return new Not(expr);}
      break;
    case UNDERSCORE:
    case NAMESPACE:
    case LABEL:
    case LANG:
    case DATATYPE:
    case LOCALNAME:
    case NULL:
    case LITERAL:
    case FULL_URI:
    case BNODE:
    case QNAME:
    case PREFIX_NAME:
    case POS_INTEGER:
    case NEG_INTEGER:
    case DECIMAL:
      expr = any_all_like_or_in();
                                                     {if (true) return expr;}
      break;
    case ISRESOURCE:
      jj_consume_token(ISRESOURCE);
      jj_consume_token(LPAREN);
      var = var();
      jj_consume_token(RPAREN);
                                                     {if (true) return new IsResource(var);}
      break;
    case ISLITERAL:
      jj_consume_token(ISLITERAL);
      jj_consume_token(LPAREN);
      var = var();
      jj_consume_token(RPAREN);
                                                     {if (true) return new IsLiteral(var);}
      break;
    case ISURI:
      jj_consume_token(ISURI);
      jj_consume_token(LPAREN);
      var = var();
      jj_consume_token(RPAREN);
                                                     {if (true) return new IsURI(var);}
      break;
    case ISBNODE:
      jj_consume_token(ISBNODE);
      jj_consume_token(LPAREN);
      var = var();
      jj_consume_token(RPAREN);
                                                     {if (true) return new IsBNode(var);}
      break;
    case EXISTS:
      jj_consume_token(EXISTS);
      jj_consume_token(LPAREN);
      qc = table_query_set();
      jj_consume_token(RPAREN);
                                                            {if (true) return new Exists(qc);}
      break;
    default:
      jj_la1[41] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public BooleanExpr any_all_like_or_in() throws ParseException {
        ValueExpr leftValue, rightValue;
        Query qc;
        int op;
        String pattern;
        boolean ignoreCase = false;
    leftValue = var_or_value();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
    case NE:
    case LT:
    case LE:
    case GE:
    case GT:
      op = comp_op();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNDERSCORE:
      case NAMESPACE:
      case LABEL:
      case LANG:
      case DATATYPE:
      case LOCALNAME:
      case NULL:
      case LITERAL:
      case FULL_URI:
      case BNODE:
      case QNAME:
      case PREFIX_NAME:
      case POS_INTEGER:
      case NEG_INTEGER:
      case DECIMAL:
        rightValue = var_or_value();
                                        {if (true) return new ValueCompare(leftValue, rightValue, op);}
        break;
      case ANY:
        jj_consume_token(ANY);
        jj_consume_token(LPAREN);
        qc = table_query_set();
        jj_consume_token(RPAREN);
                                        {if (true) return new CompareAny(leftValue, qc, op);}
        break;
      case ALL:
        jj_consume_token(ALL);
        jj_consume_token(LPAREN);
        qc = table_query_set();
        jj_consume_token(RPAREN);
                                        {if (true) return new CompareAll(leftValue, qc, op);}
        break;
      default:
        jj_la1[42] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case LIKE:
      jj_consume_token(LIKE);
      pattern = string();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IGNORE:
        jj_consume_token(IGNORE);
        jj_consume_token(CASE);
                                   ignoreCase = true;
        break;
      default:
        jj_la1[43] = jj_gen;
        ;
      }
                                {if (true) return new Like(leftValue, new StringConstant(pattern), ignoreCase);}
      break;
    case IN:
      jj_consume_token(IN);
      jj_consume_token(LPAREN);
      qc = table_query_set();
      jj_consume_token(RPAREN);
                                if (qc.getColumnHeaders().length != 1) {
                                        {if (true) throw new ParseException("Query argument for IN operator must have exactly one column.");}
                                }

                                {if (true) return new In(leftValue, qc);}
      break;
    default:
      jj_la1[44] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int comp_op() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      jj_consume_token(EQ);
               {if (true) return ValueCompare.EQ;}
      break;
    case NE:
      jj_consume_token(NE);
               {if (true) return ValueCompare.NE;}
      break;
    case LT:
      jj_consume_token(LT);
               {if (true) return ValueCompare.LT;}
      break;
    case LE:
      jj_consume_token(LE);
               {if (true) return ValueCompare.LE;}
      break;
    case GE:
      jj_consume_token(GE);
               {if (true) return ValueCompare.GE;}
      break;
    case GT:
      jj_consume_token(GT);
               {if (true) return ValueCompare.GT;}
      break;
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueExpr var_or_value() throws ParseException {
        ValueExpr expr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNDERSCORE:
    case PREFIX_NAME:
      expr = var();
                       {if (true) return expr;}
      break;
    case NAMESPACE:
    case LABEL:
    case LANG:
    case DATATYPE:
    case LOCALNAME:
    case NULL:
    case LITERAL:
    case FULL_URI:
    case BNODE:
    case QNAME:
    case POS_INTEGER:
    case NEG_INTEGER:
    case DECIMAL:
      expr = value();
                         {if (true) return expr;}
      break;
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueExpr uri_bnode_or_literal() throws ParseException {
        ValueExpr expr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FULL_URI:
    case QNAME:
      expr = uri();
                           {if (true) return expr;}
      break;
    case BNODE:
      expr = bnode();
                           {if (true) return expr;}
      break;
    case LITERAL:
    case POS_INTEGER:
    case NEG_INTEGER:
    case DECIMAL:
      expr = literal();
                           {if (true) return expr;}
      break;
    default:
      jj_la1[47] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Var var() throws ParseException {
        String varName;
    varName = nc_name();
                {if (true) return _getSharedVar(varName);}
    throw new Error("Missing return statement in function");
  }

  final public ValueExpr value() throws ParseException {
        ValueExpr expr;
        Var var;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FULL_URI:
    case QNAME:
      expr = uri();
                                                    {if (true) return expr;}
      break;
    case BNODE:
      expr = bnode();
                                                    {if (true) return expr;}
      break;
    case LITERAL:
    case POS_INTEGER:
    case NEG_INTEGER:
    case DECIMAL:
      expr = literal();
                                                    {if (true) return expr;}
      break;
    case NULL:
      expr = _null();
                                                    {if (true) return expr;}
      break;
    case DATATYPE:
      jj_consume_token(DATATYPE);
      jj_consume_token(LPAREN);
      var = var();
      jj_consume_token(RPAREN);
                                                    {if (true) return new Datatype(var);}
      break;
    case LANG:
      jj_consume_token(LANG);
      jj_consume_token(LPAREN);
      var = var();
      jj_consume_token(RPAREN);
                                                    {if (true) return new Lang(var);}
      break;
    case LABEL:
      jj_consume_token(LABEL);
      jj_consume_token(LPAREN);
      var = var();
      jj_consume_token(RPAREN);
                                                    {if (true) return new Label(var);}
      break;
    case NAMESPACE:
      jj_consume_token(NAMESPACE);
      jj_consume_token(LPAREN);
      var = var();
      jj_consume_token(RPAREN);
                                                    {if (true) return new Namespace(var);}
      break;
    case LOCALNAME:
      jj_consume_token(LOCALNAME);
      jj_consume_token(LPAREN);
      var = var();
      jj_consume_token(RPAREN);
                                                    {if (true) return new LocalName(var);}
      break;
    default:
      jj_la1[48] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ResourceExpr uri() throws ParseException {
        ResourceExpr expr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FULL_URI:
      expr = full_uri();
                            {if (true) return expr;}
      break;
    case QNAME:
      expr = qname();
                         {if (true) return expr;}
      break;
    default:
      jj_la1[49] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ResourceExpr full_uri() throws ParseException {
        Token uriToken;
    uriToken = jj_consume_token(FULL_URI);
                URI uri = _parseFullURI(uriToken.image);
                ResourceExpr result = new ResourceExpr(uri);
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public ResourceExpr qname() throws ParseException {
        Token uriToken;
    uriToken = jj_consume_token(QNAME);
                {if (true) return new ResourceExpr( _parseQName(uriToken.image) );}
    throw new Error("Missing return statement in function");
  }

  final public ResourceExpr bnode() throws ParseException {
        Token bnodeToken;
    bnodeToken = jj_consume_token(BNODE);
                {if (true) return new ResourceExpr( _parseBNode(bnodeToken.image) );}
    throw new Error("Missing return statement in function");
  }

  final public LiteralExpr literal() throws ParseException {
        Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LITERAL:
      token = jj_consume_token(LITERAL);
                        {if (true) return new LiteralExpr( _parseLiteral(token.image) );}
      break;
    case POS_INTEGER:
      token = jj_consume_token(POS_INTEGER);
                        {if (true) return new LiteralExpr( new LiteralImpl(
                                        XmlDatatypeUtil.normalizeInteger(token.image),
                                        XSD_INTEGER) );}
      break;
    case NEG_INTEGER:
      token = jj_consume_token(NEG_INTEGER);
                        {if (true) return new LiteralExpr( new LiteralImpl(
                                        XmlDatatypeUtil.normalizeInteger(token.image),
                                        XSD_INTEGER) );}
      break;
    case DECIMAL:
      token = jj_consume_token(DECIMAL);
                        {if (true) return new LiteralExpr( new LiteralImpl(
                                        XmlDatatypeUtil.normalizeDecimal(token.image),
                                        XSD_DECIMAL) );}
      break;
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String nc_name() throws ParseException {
        Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PREFIX_NAME:
      token = jj_consume_token(PREFIX_NAME);
                                {if (true) return token.image;}
      break;
    case UNDERSCORE:
      token = jj_consume_token(UNDERSCORE);
                               {if (true) return token.image;}
      break;
    default:
      jj_la1[51] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String string() throws ParseException {
        Token token;
    try {
      token = jj_consume_token(LITERAL);
    } catch (ParseException e) {
                // thrown exception reports that a <LITERAL> is
                // expected, but we actually mean a <STRING>
                {if (true) throw _createParseException(e.currentToken, new String[]{"<STRING>"});}
    }
                        Literal literal = _parseLiteral(token.image);

                        if (literal.getLanguage() != null || literal.getDatatype() != null) {
                                // Not a plain literal that can be qualified as a string
                                {if (true) throw new ParseException("Expected <STRING>, found <LITERAL>: " + literal.toString());}
                        }

                        {if (true) return literal.getLabel();}
    throw new Error("Missing return statement in function");
  }

  final public int pos_integer() throws ParseException {
        Token token;
    token = jj_consume_token(POS_INTEGER);
                        try {
                                {if (true) return Integer.parseInt( token.image );}
                        }
                        catch (NumberFormatException e) {
                                // Should never happen: tokenizer enforces that token contains a valid integer
                                {if (true) throw new RuntimeException(e);}
                        }
    throw new Error("Missing return statement in function");
  }

  final public Null _null() throws ParseException {
    jj_consume_token(NULL);
                 {if (true) return new Null();}
    throw new Error("Missing return statement in function");
  }

  public SerqlParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[52];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x400000,0x0,0x0,0x0,0x1020000,0x400000,0x0,0x0,0x0,0x2020000,0x2000,0x4000000,0x8000000,0x20000000,0x40000000,0x4000000,0x89000,0x8000000,0x20000000,0x40000000,0x2000,0xa01000,0x0,0x10000000,0x2000,0x284000,0x284000,0x88000,0x284000,0x284000,0x284000,0x284000,0x10000000,0x4000,0x280000,0x200000,0x2000,0x208000,0x208000,0x0,0x0,0x80a20000,0xa00000,0x0,0xfc0,0xfc0,0xa00000,0x0,0x800000,0x0,0x0,0x200000,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x0,0x200000,0xe0000,0xe0000,0x0,0x0,0x200000,0xe0000,0xe0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000f80,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x8,0x4,0x180ff83,0x1300f80,0x20,0x400010,0x0,0x1000f80,0x1000000,0x1000f80,0x0,0x1000000,0x0,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe01d0,0x0,0x0,0x0,0x190,0x190,0x0,0x190,0x190,0x190,0x190,0x0,0x0,0x190,0x190,0x0,0xe01d0,0xe01d0,0x0,0x0,0xe01d0,0xe01d0,0x0,0x0,0x0,0xe01d0,0xe00d0,0xe00d0,0x90,0xe0000,0x100,};
   }

  public SerqlParser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SerqlParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 52; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 52; i++) jj_la1[i] = -1;
  }

  public SerqlParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SerqlParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 52; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 52; i++) jj_la1[i] = -1;
  }

  public SerqlParser(SerqlParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 52; i++) jj_la1[i] = -1;
  }

  public void ReInit(SerqlParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 52; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[84];
    for (int i = 0; i < 84; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 52; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 84; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
