/* Generated By:JavaCC: Do not edit this line. RqlParser.java */
package org.openrdf.sesame.query.rql.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.openrdf.sesame.query.rql.model.And;
import org.openrdf.sesame.query.rql.model.ArraySelection;
import org.openrdf.sesame.query.rql.model.BooleanConstant;
import org.openrdf.sesame.query.rql.model.BooleanQuery;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.ClassSelector;
import org.openrdf.sesame.query.rql.model.ClassVar;
import org.openrdf.sesame.query.rql.model.CompareTo;
import org.openrdf.sesame.query.rql.model.Constant;
import org.openrdf.sesame.query.rql.model.DataPathSelector;
import org.openrdf.sesame.query.rql.model.DataQuery;
import org.openrdf.sesame.query.rql.model.DataVar;
import org.openrdf.sesame.query.rql.model.Domain;
import org.openrdf.sesame.query.rql.model.DomainSelector;
import org.openrdf.sesame.query.rql.model.Exists;
import org.openrdf.sesame.query.rql.model.Forall;
import org.openrdf.sesame.query.rql.model.In;
import org.openrdf.sesame.query.rql.model.InstanceOf;
import org.openrdf.sesame.query.rql.model.InstanceSelector;
import org.openrdf.sesame.query.rql.model.IntegerConstant;
import org.openrdf.sesame.query.rql.model.Intersect;
import org.openrdf.sesame.query.rql.model.Like;
import org.openrdf.sesame.query.rql.model.Minus;
import org.openrdf.sesame.query.rql.model.Not;
import org.openrdf.sesame.query.rql.model.Or;
import org.openrdf.sesame.query.rql.model.PropertyQuery;
import org.openrdf.sesame.query.rql.model.PropertySelector;
import org.openrdf.sesame.query.rql.model.PropertyVar;
import org.openrdf.sesame.query.rql.model.Query;
import org.openrdf.sesame.query.rql.model.Range;
import org.openrdf.sesame.query.rql.model.RangeSelector;
import org.openrdf.sesame.query.rql.model.RdfProperty;
import org.openrdf.sesame.query.rql.model.RdfsClass;
import org.openrdf.sesame.query.rql.model.RealConstant;
import org.openrdf.sesame.query.rql.model.ResourceQuery;
import org.openrdf.sesame.query.rql.model.SetQuery;
import org.openrdf.sesame.query.rql.model.SfwQuery;
import org.openrdf.sesame.query.rql.model.StringConstant;
import org.openrdf.sesame.query.rql.model.SubClassOf;
import org.openrdf.sesame.query.rql.model.SubPropertyOf;
import org.openrdf.sesame.query.rql.model.SuperClassOf;
import org.openrdf.sesame.query.rql.model.SuperPropertyOf;
import org.openrdf.sesame.query.rql.model.TypeOf;
import org.openrdf.sesame.query.rql.model.URI;
import org.openrdf.sesame.query.rql.model.Union;
import org.openrdf.sesame.query.rql.model.UnknownSelector;
import org.openrdf.sesame.query.rql.model.Var;

public class RqlParser implements RqlParserConstants {

        protected Map _varMap = new HashMap();
        protected List _varList = new ArrayList();
        protected List _unboundVarList = new ArrayList();

        public Var getSharedVar(String name) {
                Var result = (Var)_varMap.get(name);
                if (result == null) {
                        // Create a new Var
                        if (name.startsWith("$")) {
//System.out.println("Creating new ClassVar: " + name);
                                result = new ClassVar(name);
                        }
                        else if (name.startsWith("@")) {
//System.out.println("Creating new PropertyVar: " + name);
                                result = new PropertyVar(name);
                        }
                        else {
//System.out.println("Creating new DataVar: " + name);
                                result = new DataVar(name);
                        }
                        _varMap.put(name, result);
                        _varList.add(result);
                        _unboundVarList.add(result);
                }
                return result;
        }

        public List getVarList() {
                return _varList;
        }

        public void clearVars() {
                _varMap.clear();
                _varList = new ArrayList();
        }

        private int _varNo = 1;
        public String getAnonymousVarName() {
                return "_" + _varNo++;
        }

        /** namespaces **/
        protected Map _nsMap = new HashMap();

        public void addNamespace(String prefix, String namespace) {
                _nsMap.put(prefix, namespace);
        }

        public String getNamespace(String prefix) {
                return (String)_nsMap.get(prefix);
        }

        // non-public "struct"
        static class FromTo {
                DataVar dataVar;
                ClassQuery classQ;
        }

  final public Query parse() throws ParseException {
        Query q;

        // (re)set _varNo to '1'.
        _varNo = 1;
          clearVars();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USING:
      jj_consume_token(USING);
      jj_consume_token(NAMESPACE);
      namespace();
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[0] = jj_gen;
          break label_1;
        }
        jj_consume_token(COMMA);
        namespace();
      }
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    q = query();
    jj_consume_token(0);
                if (_unboundVarList.size() > 0) {
                        String msg = "Unbound variable(s): ";

                        for (int i = 0; i < _unboundVarList.size(); i++) {
                                Var var = (Var)_unboundVarList.get(i);
                                if (i > 0) {
                                        msg += ", ";
                                }
                                msg += var.getName();
                        }

                        {if (true) throw new ParseException(msg);}
                }
                {if (true) return q;}
    throw new Error("Missing return statement in function");
  }

/*-------------------------------------------------+
| NAMESPACE DECLARATIONS                           |
+-------------------------------------------------*/
  final public void namespace() throws ParseException {
        Token prefixToken, nsToken;
    prefixToken = jj_consume_token(IDENTIFIER);
    jj_consume_token(EQ);
    nsToken = jj_consume_token(URI);
                String prefix = prefixToken.image;
                String ns = nsToken.image;

                //FIXME: check if prefix isn't used twice?
                addNamespace(prefix, ns);
  }

/*-------------------------------------------------+
| QUERY                                            |
+-------------------------------------------------*/
  final public Query query() throws ParseException {
        Query q;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
      q = sfw_query();
                          {if (true) return q;}
      break;
    case URI:
      q = uri();
                    {if (true) return q;}
      break;
    case CIRCUMFLEX:
    case IDENTIFIER:
      q = data_query();
                           {if (true) return q;}
      break;
    case CLASS:
    case TYPEOF:
    case SUBCLASSOF:
    case SUPERCLASSOF:
    case DOMAIN:
    case RANGE:
    case CLASSVAR:
      q = class_query();
                            {if (true) return q;}
      break;
    case PROPERTY:
    case SUBPROPERTYOF:
    case SUPERPROPERTYOF:
    case PROPERTYVAR:
      q = property_query();
                               {if (true) return q;}
      break;
    case LPAREN:
      q = set_query();
                          {if (true) return q;}
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*-------------------------------------------------+
| VARIABLES                                        |
+-------------------------------------------------*/
  final public Var var() throws ParseException {
        Var v;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      v = datavar();
                           {if (true) return v;}
      break;
    case CLASSVAR:
      v = classvar();
                           {if (true) return v;}
      break;
    case PROPERTYVAR:
      v = propertyvar();
                           {if (true) return v;}
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public DataVar datavar() throws ParseException {
        Token t;
    t = jj_consume_token(IDENTIFIER);
                          {if (true) return (DataVar)getSharedVar(t.image);}
    throw new Error("Missing return statement in function");
  }

  final public ClassVar classvar() throws ParseException {
        Token t;
    t = jj_consume_token(CLASSVAR);
                        {if (true) return (ClassVar)getSharedVar(t.image);}
    throw new Error("Missing return statement in function");
  }

  final public PropertyVar propertyvar() throws ParseException {
        Token t;
    t = jj_consume_token(PROPERTYVAR);
                           {if (true) return (PropertyVar)getSharedVar(t.image);}
    throw new Error("Missing return statement in function");
  }

/*-------------------------------------------------+
| URI's                                            |
+-------------------------------------------------*/
  final public URI uri() throws ParseException {
        Token t;
    t = jj_consume_token(URI);
                String uriString = t.image;

                int colonIdx = uriString.indexOf(':');
                if (colonIdx != -1) {
                        String prefix = uriString.substring(0, colonIdx);
                        String namespace = getNamespace(prefix);
                        if (namespace != null) {
                                uriString = namespace + uriString.substring(colonIdx + 1);
                        }
                }

                {if (true) return new URI(uriString);}
    throw new Error("Missing return statement in function");
  }

/*-------------------------------------------------+
| SFW QUERY                                        |
+-------------------------------------------------*/
  final public ResourceQuery sfw_query() throws ParseException {
        List projsList = new ArrayList();
        List rangesList = new ArrayList();
        BooleanQuery where = null;
    jj_consume_token(SELECT);
    projslist(projsList);
    jj_consume_token(FROM);
    rangeslist(rangesList);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      jj_consume_token(WHERE);
      where = boolean_query();
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
                if (projsList.isEmpty()) {
                        // select *
                        projsList = getVarList();
                }
                {if (true) return new SfwQuery(projsList, rangesList, where);}
    throw new Error("Missing return statement in function");
  }

  final public void projslist(List projsList) throws ParseException {
        ResourceQuery q;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASTERISK:
      jj_consume_token(ASTERISK);
      break;
    case TYPEOF:
    case SUBCLASSOF:
    case SUPERCLASSOF:
    case SUBPROPERTYOF:
    case SUPERPROPERTYOF:
    case DOMAIN:
    case RANGE:
    case NULL:
    case IDENTIFIER:
    case CLASSVAR:
    case PROPERTYVAR:
    case URI:
      q = projs_elem();
                             projsList.add(q);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[5] = jj_gen;
          break label_2;
        }
        jj_consume_token(COMMA);
        q = projs_elem();
                                             projsList.add(q);
      }
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public ResourceQuery projs_elem() throws ParseException {
        ResourceQuery q;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
    case CLASSVAR:
    case PROPERTYVAR:
      q = var();
                       {if (true) return q;}
      break;
    case NULL:
      q = null_value();
                           {if (true) return q;}
      break;
    case URI:
      q = uri();
                       {if (true) return q;}
      break;
    case DOMAIN:
      q = domain();
                       {if (true) return q;}
      break;
    case RANGE:
      q = range();
                       {if (true) return q;}
      break;
    case SUBCLASSOF:
      q = subClassOf();
                           {if (true) return q;}
      break;
    case SUBPROPERTYOF:
      q = subPropertyOf();
                              {if (true) return q;}
      break;
    case TYPEOF:
      q = typeOf();
                       {if (true) return q;}
      break;
    case SUPERPROPERTYOF:
      q = superPropertyOf();
                                {if (true) return q;}
      break;
    case SUPERCLASSOF:
      q = superClassOf();
                             {if (true) return q;}
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public DataVar null_value() throws ParseException {
    Token t;
    t = jj_consume_token(NULL);
        // FIXME a null token is now returned as a DataVar, because there is
        // no specific 'nulltoken' object in the data model. should we change
        // this?
        {if (true) return new DataVar(t.image);}
    throw new Error("Missing return statement in function");
  }

  final public void rangeslist(List selectors) throws ParseException {
    ranges_elem(selectors);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      ranges_elem(selectors);
    }
  }

  final public void ranges_elem(List selectors) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASS:
    case PROPERTY:
      class_or_property_selector(selectors);
      break;
    case LBRACE:
    case TYPEOF:
    case SUBCLASSOF:
    case SUPERCLASSOF:
    case SUBPROPERTYOF:
    case SUPERPROPERTYOF:
    case DOMAIN:
    case RANGE:
    case CLASSVAR:
    case PROPERTYVAR:
    case URI:
      pathexpr(selectors);
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void class_or_property_selector(List selectors) throws ParseException {
        RdfsClass rdfsClass;
        ClassVar classVar;
        RdfProperty rdfProperty;
        PropertyVar propVar;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASS:
      rdfsClass = rdfs_class();
      jj_consume_token(LBRACE);
      classVar = classvar();
      jj_consume_token(RBRACE);
                ClassSelector classSel = new ClassSelector(classVar, rdfsClass);
                _unboundVarList.remove(classVar);
                selectors.add(classSel);
      break;
    case PROPERTY:
      rdfProperty = rdf_property();
      jj_consume_token(LBRACE);
      propVar = propertyvar();
      jj_consume_token(RBRACE);
                PropertySelector propSel = new PropertySelector(propVar, rdfProperty);
                _unboundVarList.remove(propVar);
                selectors.add(propSel);
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void pathexpr(List selectors) throws ParseException {
        // Vars for implicit joins between path elements
        FromTo fromTo = new FromTo();
    fromTo = first_pathelem(selectors);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        ;
        break;
      default:
        jj_la1[11] = jj_gen;
        break label_4;
      }
      fromTo = joined_pathelem(selectors, fromTo);
    }
  }

/* The first path element of a row (possibly) */
  final public FromTo first_pathelem(List selectors) throws ParseException {
        FromTo sourceFromTo = null;
        FromTo targetFromTo = null;

        PropertyQuery propQ = null;
        ClassQuery classQ = null;
        URI uri = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      jj_consume_token(LBRACE);
      sourceFromTo = from_to(selectors);
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROPERTY:
    case SUBPROPERTYOF:
    case SUPERPROPERTYOF:
    case PROPERTYVAR:
      propQ = property_query();
      break;
    case CLASS:
    case TYPEOF:
    case SUBCLASSOF:
    case SUPERCLASSOF:
    case DOMAIN:
    case RANGE:
    case CLASSVAR:
      classQ = class_query();
      break;
    case URI:
      uri = uri();
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      jj_consume_token(LBRACE);
      targetFromTo = from_to(selectors);
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
                if (classQ != null) {
                        if (targetFromTo == null) {
                                {if (true) throw new ParseException("from_to part missing for " +
                                                classQ.toString());}
                        }
                        if (sourceFromTo != null) {
                                {if (true) throw new ParseException("Not a property query: " +
                                                classQ.toString());}
                        }
                        if (targetFromTo.dataVar == null) {
                                if (targetFromTo.classQ == null) {
                                        {if (true) throw new ParseException("Data or class var missing for " +
                                                        classQ.toString());}
                                }
                                else if (targetFromTo.classQ instanceof ClassVar) {
                                        // Query like: classQ { : $X}
                                        ClassSelector classSel = new
                                                ClassSelector((ClassVar)targetFromTo.classQ, classQ);
                                        _unboundVarList.remove(targetFromTo.classQ);
                                        _unboundVarList.remove(classQ);
                                        selectors.add(classSel);
                                }
                                else {
                                        {if (true) throw new ParseException("target should be class var for " +
                                                        classQ.toString());}
                                }
                        }
                        else {
                                // Query like: classQ {X}
                                InstanceSelector insSel = new InstanceSelector(
                                                targetFromTo.dataVar, classQ, false);
                                _unboundVarList.remove(targetFromTo.dataVar);
                                _unboundVarList.remove(classQ);
                                selectors.add(insSel);
                        }
                }
                else if (uri != null) {

                        if (sourceFromTo == null &&
                            targetFromTo != null &&
                            targetFromTo.classQ != null &&
                            targetFromTo.classQ instanceof ClassVar)
                        {
                                // query is of the form 'uri{ : $X}' or 'uri{X : $X}'

                                // FIXME what if targetFromTo.classQ is not just a var?

                                // create a class selector constraining $X to subclasses
                                // of uri. FIXME currently subClassOf(X) does not return X
                                // itself, this is necessary here.
                                classQ = new SubClassOf((ClassQuery)uri, true);
                                ClassSelector classSel = new ClassSelector((ClassVar)targetFromTo.classQ, classQ);
                                _unboundVarList.remove(targetFromTo.classQ);
                                _unboundVarList.remove(classQ);
                                selectors.add(classSel);

                                if (targetFromTo.dataVar != null) {
                                        InstanceSelector instSel = new InstanceSelector(targetFromTo.dataVar, targetFromTo.classQ, true);
                                        _unboundVarList.remove(targetFromTo.dataVar);
                                        _unboundVarList.remove(targetFromTo.classQ);
                                        selectors.add(instSel);
                                }
                        }
                        else if (sourceFromTo != null ||
                                 targetFromTo == null ||        // implicit join using "."
                                 targetFromTo.dataVar == null || // schema path selector
                                 targetFromTo.classQ != null)    // schema path selector
                        {
                                // This is a property selector. This will be handled in
                                // the next if-statement
                                propQ = (PropertyQuery)uri;
                        }
                        else {
                                // Don't know what kind of selector this is, use an
                                // UnknownSelector
                                UnknownSelector unknownSel = new UnknownSelector(
                                                uri, targetFromTo.dataVar);
                                _unboundVarList.remove(targetFromTo.dataVar);
                                selectors.add(unknownSel);
                        }
                }
                // Not 'else if' because propQ can be set later in case of uri !!!
                if (propQ != null) {
                        // Both FromTo's are needed:
                        if (sourceFromTo == null) {
                                sourceFromTo = new FromTo();
                        }
                        if (targetFromTo == null) {
                                targetFromTo = new FromTo();
                        }

                        // In case just one of the FromTo's has a dataVar, the other
                        // should get an anonymous DataVar.
                        if (sourceFromTo.dataVar != null) {
                                if (targetFromTo.dataVar == null) {
                                        targetFromTo.dataVar = new DataVar(getAnonymousVarName());

                                        if (targetFromTo.classQ != null) {
                                                // We've created a new class restriction
                                                InstanceSelector resSel = new InstanceSelector(
                                                                targetFromTo.dataVar, targetFromTo.classQ,
                                                                true);
                                                _unboundVarList.remove(targetFromTo.classQ);
                                                selectors.add(resSel);
                                        }
                                }
                        }
                        else { // sourceFromTo.dataVar == null
                                if (targetFromTo.dataVar != null) {
                                        sourceFromTo.dataVar = new DataVar(getAnonymousVarName());

                                        if (sourceFromTo.classQ != null) {
                                                // We've created a new class restriction
                                                InstanceSelector resSel = new InstanceSelector(
                                                                sourceFromTo.dataVar, sourceFromTo.classQ,
                                                                true);
                                                _unboundVarList.remove(sourceFromTo.classQ);
                                                selectors.add(resSel);
                                        }
                                }
                        }

                        // Now both FromTo's are ensured to be complete


                        // Create a property selector for the property in case propQ
                        // is not a PropertyVar itself
                        PropertyVar propVar = null;
                        if (propQ instanceof PropertyVar) {
                                propVar = (PropertyVar)propQ;
                                // If both source and target are empty
                                // (e.g. {} @P {} ), we still need a
                                // property selector.
                                if (sourceFromTo.dataVar == null &&
                                    targetFromTo.dataVar == null)
                                {
                                    PropertySelector propSel =
                                        new PropertySelector(propVar, new RdfProperty());
                                    _unboundVarList.remove(propVar);
                                    selectors.add(propSel);
                                }
                        }
                        else {
                                // Use anonymous var that can be shared with other selectors
                                propVar = new PropertyVar(getAnonymousVarName());
                                PropertySelector propSel = new PropertySelector(propVar, propQ);
                                _unboundVarList.remove(propQ);
                                selectors.add(propSel);
                        }


                        // If appropriate, create DataPathSelector
                        if (sourceFromTo.dataVar != null &&
                                targetFromTo.dataVar != null)
                        {
                                boolean extendedPropInterpretation = true;
                                if (propQ instanceof PropertyVar) {
                                        extendedPropInterpretation = false;
                                }
                                DataPathSelector dps = new DataPathSelector(
                                                sourceFromTo.dataVar, propVar, targetFromTo.dataVar,
                                                extendedPropInterpretation);
                                _unboundVarList.remove(sourceFromTo.dataVar);
                                _unboundVarList.remove(propVar);
                                _unboundVarList.remove(targetFromTo.dataVar);
                                selectors.add(dps);
                        }

                        // If appropriate, create DomainSelector
                        if (sourceFromTo.classQ != null) {
                                DomainSelector domainSel = new DomainSelector(
                                                sourceFromTo.classQ, propVar);
                                _unboundVarList.remove(propVar);
                                _unboundVarList.remove(sourceFromTo.classQ);
                                selectors.add(domainSel);
                        }

                        // If appropriate, create RangeSelector
                        if (targetFromTo.classQ != null) {
                                RangeSelector rangeSel = new RangeSelector(
                                                propVar, targetFromTo.classQ);
                                _unboundVarList.remove(propVar);
                                _unboundVarList.remove(targetFromTo.classQ);
                                selectors.add(rangeSel);
                        }
                }

                // Return target FromTo for implicit join with next path element
                {if (true) return targetFromTo;}
    throw new Error("Missing return statement in function");
  }

/*
 * A path element whose domain is joined with the range of another
 * using a ".". The supplied sourceFromTo containing the range of the
 * other path element must never be null.
 */
  final public FromTo joined_pathelem(List selectors, FromTo sourceFromTo) throws ParseException {
        FromTo targetFromTo = null;
        PropertyQuery propQ = null;
    jj_consume_token(DOT);
    propQ = ext_property_query();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      jj_consume_token(LBRACE);
      targetFromTo = from_to(selectors);
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
                // targetFromTo must always be present for implicit joins
                // with next path element:
                if (targetFromTo == null) {
                        targetFromTo = new FromTo();
                }

                // In case just one of the FromTo's has a dataVar, the other
                // should get an anonymous DataVar.
                if (sourceFromTo.dataVar != null) {
                        if (targetFromTo.dataVar == null) {
                                targetFromTo.dataVar = new DataVar(getAnonymousVarName());

                                if (targetFromTo.classQ != null) {
                                        // We've created a new class restriction
                                        InstanceSelector resSel = new InstanceSelector(
                                                        targetFromTo.dataVar, targetFromTo.classQ,
                                                        true);
                                        _unboundVarList.remove(targetFromTo.dataVar);
                                        _unboundVarList.remove(targetFromTo.classQ);
                                        selectors.add(resSel);
                                }
                        }
                }
                else { // sourceFromTo.dataVar == null
                        if (targetFromTo.dataVar != null) { //
                                sourceFromTo.dataVar = new DataVar(getAnonymousVarName());

                                if (sourceFromTo.classQ != null) {
                                        // We've created a new class restriction
                                        InstanceSelector resSel = new InstanceSelector(
                                                        sourceFromTo.dataVar, sourceFromTo.classQ,
                                                        true);
                                        _unboundVarList.remove(sourceFromTo.dataVar);
                                        _unboundVarList.remove(sourceFromTo.classQ);
                                        selectors.add(resSel);
                                }
                        }
                }

                // Create a property selector for the property in case propQ
                // is not a PropertyVar itself
                PropertyVar propVar = null;
                if (propQ instanceof PropertyVar) {
                        propVar = (PropertyVar)propQ;
                }
                else {
                        // Use anonymous var that can be shared with other selectors
                        propVar = new PropertyVar(getAnonymousVarName());
                        PropertySelector propSel = new PropertySelector(propVar, propQ);
                        _unboundVarList.remove(propQ);
                        selectors.add(propSel);
                }

                // If appropriate, create DataPathSelector
                if (targetFromTo.dataVar != null) {
                        boolean extendedPropInterpretation = true;
                        if (propQ instanceof PropertyVar) {
                                extendedPropInterpretation = false;
                        }
                        DataPathSelector dps = new DataPathSelector(
                                        sourceFromTo.dataVar, propVar, targetFromTo.dataVar,
                                        extendedPropInterpretation);
                        _unboundVarList.remove(sourceFromTo.dataVar);
                        _unboundVarList.remove(propVar);
                        _unboundVarList.remove(targetFromTo.dataVar);
                        selectors.add(dps);
                }

                // If appropriate, create DomainSelector
                if (sourceFromTo.classQ != null) {
                        DomainSelector domainSel = new DomainSelector(
                                        sourceFromTo.classQ, propVar);
                        _unboundVarList.remove(propVar);
                        _unboundVarList.remove(sourceFromTo.classQ);
                        selectors.add(domainSel);
                }

                // If appropriate, create RangeSelector
                if (targetFromTo.classQ != null) {
                        RangeSelector rangeSel = new RangeSelector(
                                        propVar, targetFromTo.classQ);
                        _unboundVarList.remove(propVar);
                        _unboundVarList.remove(targetFromTo.classQ);
                        selectors.add(rangeSel);
                }

                // Return target FromTo for implicit join with next path element
                {if (true) return targetFromTo;}
    throw new Error("Missing return statement in function");
  }

  final public FromTo from_to(List selectors) throws ParseException {
        FromTo result = new FromTo();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      result.dataVar = datavar();
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      jj_consume_token(COLON);
      result.classQ = schema_part();
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
                if (result.dataVar != null && result.classQ != null) {
                    // if of the form {X : someClass} do extended
                    // interpretation, but if the schema constraint is
                    // more complex do restricted interpretation.
                    boolean properInstancesOnly = true;
                    if (result.classQ instanceof URI) {
                        properInstancesOnly = false;
                    }
                    InstanceSelector resSel = new InstanceSelector(
                            result.dataVar, result.classQ,
                            properInstancesOnly);
                    _unboundVarList.remove(result.dataVar);
                    _unboundVarList.remove(result.classQ);
                    selectors.add(resSel);

                }
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public ClassQuery schema_part() throws ParseException {
        ClassQuery result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CLASSVAR:
      result = classvar();
                              {if (true) return result;}
      break;
    case URI:
      result = uri();
                         {if (true) return result;}
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*-------------------------------------------------+
| DATA QUERIES                                     |
+-------------------------------------------------*/
  final public DataQuery ext_data_query() throws ParseException {
        DataQuery result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case URI:
      result = uri();
                         {if (true) return result;}
      break;
    case CIRCUMFLEX:
    case IDENTIFIER:
      result = data_query();
                                {if (true) return result;}
      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public DataQuery data_query() throws ParseException {
        ResourceQuery result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      result = datavar();
          {if (true) return (DataQuery)result;}
      break;
    case CIRCUMFLEX:
      result = proper_instances();
      result = array_selection(result);
          {if (true) return (DataQuery)result;}
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public DataQuery proper_instances() throws ParseException {
        ClassQuery cq;
    jj_consume_token(CIRCUMFLEX);
    cq = ext_class_query();
          {if (true) return new InstanceOf(cq, true);}
    throw new Error("Missing return statement in function");
  }

/*-------------------------------------------------+
| CLASS QUERIES                                    |
+-------------------------------------------------*/

/* Extended class query = class_query + schemavar + uri */
  final public ClassQuery ext_class_query() throws ParseException {
        ResourceQuery result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case URI:
      result = uri();
          {if (true) return (ClassQuery)result;}
      break;
    case CLASS:
    case TYPEOF:
    case SUBCLASSOF:
    case SUPERCLASSOF:
    case DOMAIN:
    case RANGE:
    case CLASSVAR:
      result = class_query();
          {if (true) return (ClassQuery)result;}
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ClassQuery class_query() throws ParseException {
        ResourceQuery result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TYPEOF:
      result = typeOf();
      result = array_selection(result);
          {if (true) return (ClassQuery)result;}
      break;
    case SUBCLASSOF:
      result = subClassOf();
      result = array_selection(result);
          {if (true) return (ClassQuery)result;}
      break;
    case SUPERCLASSOF:
      result = superClassOf();
      result = array_selection(result);
          {if (true) return (ClassQuery)result;}
      break;
    case DOMAIN:
      result = domain();
                            {if (true) return (ClassQuery)result;}
      break;
    case RANGE:
      result = range();
                           {if (true) return (ClassQuery)result;}
      break;
    case CLASSVAR:
      result = classvar();
                              {if (true) return (ClassQuery)result;}
      break;
    case CLASS:
      result = rdfs_class();
      result = array_selection(result);
          {if (true) return (ClassQuery)result;}
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ClassQuery typeOf() throws ParseException {
        ResourceQuery rq;
        Token t = null;
    jj_consume_token(TYPEOF);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CIRCUMFLEX:
      t = jj_consume_token(CIRCUMFLEX);
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    jj_consume_token(LPAREN);
    rq = typeOf_arg();
    jj_consume_token(RPAREN);
          {if (true) return new TypeOf(rq, (t == null));}
    throw new Error("Missing return statement in function");
  }

  final public ResourceQuery typeOf_arg() throws ParseException {
    ResourceQuery rq;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CIRCUMFLEX:
    case IDENTIFIER:
    case URI:
      // FIXME why not just all resourcequeries?
          rq = ext_data_query();
                            {if (true) return rq;}
      break;
    case PROPERTY:
    case SUBPROPERTYOF:
    case SUPERPROPERTYOF:
    case PROPERTYVAR:
      rq = property_query();
                            {if (true) return rq;}
      break;
    case CLASS:
    case TYPEOF:
    case SUBCLASSOF:
    case SUPERCLASSOF:
    case DOMAIN:
    case RANGE:
    case CLASSVAR:
      rq = class_query();
                         {if (true) return rq;}
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ClassQuery subClassOf() throws ParseException {
        ClassQuery cq;
        Token t = null;
    jj_consume_token(SUBCLASSOF);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CIRCUMFLEX:
      t = jj_consume_token(CIRCUMFLEX);
      break;
    default:
      jj_la1[25] = jj_gen;
      ;
    }
    jj_consume_token(LPAREN);
    cq = ext_class_query();
    jj_consume_token(RPAREN);
          {if (true) return new SubClassOf(cq, (t == null));}
    throw new Error("Missing return statement in function");
  }

  final public ClassQuery superClassOf() throws ParseException {
        ClassQuery cq;
        Token t = null;
    jj_consume_token(SUPERCLASSOF);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CIRCUMFLEX:
      t = jj_consume_token(CIRCUMFLEX);
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
    jj_consume_token(LPAREN);
    cq = ext_class_query();
    jj_consume_token(RPAREN);
          {if (true) return new SuperClassOf(cq, (t == null));}
    throw new Error("Missing return statement in function");
  }

  final public RdfsClass rdfs_class() throws ParseException {
    jj_consume_token(CLASS);
                  {if (true) return new RdfsClass();}
    throw new Error("Missing return statement in function");
  }

  final public ClassQuery domain() throws ParseException {
        PropertyQuery pq;
    jj_consume_token(DOMAIN);
    jj_consume_token(LPAREN);
    pq = ext_property_query();
    jj_consume_token(RPAREN);
          {if (true) return new Domain(pq);}
    throw new Error("Missing return statement in function");
  }

  final public ClassQuery range() throws ParseException {
        PropertyQuery pq;
    jj_consume_token(RANGE);
    jj_consume_token(LPAREN);
    pq = ext_property_query();
    jj_consume_token(RPAREN);
          {if (true) return new Range(pq);}
    throw new Error("Missing return statement in function");
  }

/*-------------------------------------------------+
| PROPERTY QUERIES                                 |
+-------------------------------------------------*/

/* Extended property query = property_query + schemavar + uri */
  final public PropertyQuery ext_property_query() throws ParseException {
        PropertyQuery result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case URI:
      result = uri();
                         {if (true) return result;}
      break;
    case PROPERTY:
    case SUBPROPERTYOF:
    case SUPERPROPERTYOF:
    case PROPERTYVAR:
      result = property_query();
                                    {if (true) return result;}
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public PropertyQuery property_query() throws ParseException {
        ResourceQuery result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUBPROPERTYOF:
      result = subPropertyOf();
      result = array_selection(result);
          {if (true) return (PropertyQuery)result;}
      break;
    case SUPERPROPERTYOF:
      result = superPropertyOf();
      result = array_selection(result);
          {if (true) return (PropertyQuery)result;}
      break;
    case PROPERTYVAR:
      result = propertyvar();
          {if (true) return (PropertyQuery)result;}
      break;
    case PROPERTY:
      result = rdf_property();
      result = array_selection(result);
          {if (true) return (PropertyQuery)result;}
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public PropertyQuery subPropertyOf() throws ParseException {
        PropertyQuery pq;
        Token t = null;
    jj_consume_token(SUBPROPERTYOF);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CIRCUMFLEX:
      t = jj_consume_token(CIRCUMFLEX);
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    jj_consume_token(LPAREN);
    pq = ext_property_query();
    jj_consume_token(RPAREN);
          {if (true) return new SubPropertyOf(pq, (t == null));}
    throw new Error("Missing return statement in function");
  }

  final public PropertyQuery superPropertyOf() throws ParseException {
        PropertyQuery pq;
        Token t = null;
    jj_consume_token(SUPERPROPERTYOF);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CIRCUMFLEX:
      t = jj_consume_token(CIRCUMFLEX);
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
    jj_consume_token(LPAREN);
    pq = ext_property_query();
    jj_consume_token(RPAREN);
          {if (true) return new SuperPropertyOf(pq, (t == null));}
    throw new Error("Missing return statement in function");
  }

  final public RdfProperty rdf_property() throws ParseException {
    jj_consume_token(PROPERTY);
                     {if (true) return new RdfProperty();}
    throw new Error("Missing return statement in function");
  }

/*-------------------------------------------------+
| RESOURCE QUERIES                                 |
+-------------------------------------------------*/

// Only used within boolean_query
  final public ResourceQuery resource_query() throws ParseException {
        ResourceQuery r;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case URI:
      r = uri();
                    {if (true) return r;}
      break;
    case CIRCUMFLEX:
    case IDENTIFIER:
      r = data_query();
                                              {if (true) return r;}
      break;
    case CLASS:
    case TYPEOF:
    case SUBCLASSOF:
    case SUPERCLASSOF:
    case DOMAIN:
    case RANGE:
    case CLASSVAR:
      r = class_query();
                                               {if (true) return r;}
      break;
    case PROPERTY:
    case SUBPROPERTYOF:
    case SUPERPROPERTYOF:
    case PROPERTYVAR:
      r = property_query();
                                                  {if (true) return r;}
      break;
    case SELECT:
      r = sfw_query();
                          {if (true) return r;}
      break;
    case INTEGER_LITERAL:
    case REAL_LITERAL:
    case QUOTED_STRING:
    case QUOTED_CHAR:
      r = constant();
                         {if (true) return r;}
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ResourceQuery array_selection(ResourceQuery subject) throws ParseException {
        Token startIdx = null;
        Token endIdx = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      jj_consume_token(LBRACKET);
      startIdx = jj_consume_token(INTEGER_LITERAL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        jj_consume_token(COLON);
        endIdx = jj_consume_token(INTEGER_LITERAL);
        break;
      default:
        jj_la1[32] = jj_gen;
        ;
      }
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[33] = jj_gen;
      ;
    }
                if (startIdx != null) {
                        int idx1, idx2;

                        idx1 = Integer.parseInt(startIdx.image);

                        if (endIdx == null) {
                                idx2 = idx1;
                        } else {
                                idx2 = Integer.parseInt(endIdx.image);
                        }

                        subject = new ArraySelection(subject, idx1, idx2);
                }

                {if (true) return subject;}
    throw new Error("Missing return statement in function");
  }

  final public SetQuery set_query() throws ParseException {
        ResourceQuery arg1;
        ResourceQuery arg2;
        Token setOp;
    jj_consume_token(LPAREN);
    arg1 = sfw_query();
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNION:
      setOp = jj_consume_token(UNION);
      break;
    case INTERSECT:
      setOp = jj_consume_token(INTERSECT);
      break;
    case MINUS:
      setOp = jj_consume_token(MINUS);
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          clearVars();
    jj_consume_token(LPAREN);
    arg2 = sfw_query();
    jj_consume_token(RPAREN);
            if (setOp.image.equals("union")) {
                {if (true) return new Union((SfwQuery)arg1, (SfwQuery)arg2);}
            }
            else if (setOp.image.equals("intersect")) {
                {if (true) return new Intersect((SfwQuery)arg1, (SfwQuery)arg2);}
            }
            else {
                {if (true) return new Minus((SfwQuery)arg1, (SfwQuery)arg2);}
            }
    throw new Error("Missing return statement in function");
  }

/*-------------------------------------------------+
| BOOLEAN QUERIES                                  |
+-------------------------------------------------*/
  final public BooleanQuery boolean_query() throws ParseException {
        BooleanQuery result;
    result = or_expression();
                                   {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public BooleanQuery or_expression() throws ParseException {
        BooleanQuery arg1;
        BooleanQuery arg2 = null;
    arg1 = and_expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OR:
      jj_consume_token(OR);
      arg2 = or_expression();
      break;
    default:
      jj_la1[35] = jj_gen;
      ;
    }
                if (arg2 == null) {
                        {if (true) return arg1;}
                }
                else {
                        {if (true) return new Or(arg1, arg2);}
                }
    throw new Error("Missing return statement in function");
  }

  final public BooleanQuery and_expression() throws ParseException {
        BooleanQuery arg1;
        BooleanQuery arg2 = null;
    arg1 = and_part();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AND:
      jj_consume_token(AND);
      arg2 = and_expression();
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
                if (arg2 == null) {
                        {if (true) return arg1;}
                }
                else {
                        {if (true) return new And(arg1, arg2);}
                }
    throw new Error("Missing return statement in function");
  }

  final public BooleanQuery and_part() throws ParseException {
        BooleanQuery bq;
        ResourceQuery rq;
        Var var;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
                 {if (true) return new BooleanConstant(true);}
      break;
    case FALSE:
      jj_consume_token(FALSE);
                  {if (true) return new BooleanConstant(false);}
      break;
    case NOT:
      jj_consume_token(NOT);
      bq = and_part();
                                {if (true) return new Not(bq);}
      break;
    case EXISTS:
      jj_consume_token(EXISTS);
      var = var();
      rq = resource_query();
      jj_consume_token(COLON);
      bq = boolean_query();
          {if (true) return new Exists(var, rq, bq);}
      break;
    case FORALL:
      jj_consume_token(FORALL);
      var = var();
      rq = resource_query();
      jj_consume_token(COLON);
      bq = boolean_query();
          {if (true) return new Forall(var, rq, bq);}
      break;
    case CIRCUMFLEX:
    case SELECT:
    case CLASS:
    case PROPERTY:
    case TYPEOF:
    case SUBCLASSOF:
    case SUPERCLASSOF:
    case SUBPROPERTYOF:
    case SUPERPROPERTYOF:
    case DOMAIN:
    case RANGE:
    case IDENTIFIER:
    case CLASSVAR:
    case PROPERTYVAR:
    case INTEGER_LITERAL:
    case REAL_LITERAL:
    case QUOTED_STRING:
    case QUOTED_CHAR:
    case URI:
      rq = resource_query();
      bq = compare_to_part(rq);
                                                         {if (true) return bq;}
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      bq = boolean_query();
      jj_consume_token(RPAREN);
                                                 {if (true) return bq;}
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public BooleanQuery compare_to_part(ResourceQuery arg1) throws ParseException {
        int op;
        ResourceQuery arg2;
        StringConstant sc;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
    case LE:
    case EQ:
    case GE:
    case GT:
    case NE:
      op = comp_op();
      arg2 = resource_query();
          {if (true) return new CompareTo(arg1, op, arg2);}
      break;
    case LIKE:
      jj_consume_token(LIKE);
      sc = quoted_string();
          {if (true) return new Like(arg1, sc);}
      break;
    case IN:
      jj_consume_token(IN);
      arg2 = resource_query();
          {if (true) return new In(arg1, arg2);}
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int comp_op() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      jj_consume_token(LT);
               {if (true) return CompareTo.LT;}
      break;
    case LE:
      jj_consume_token(LE);
               {if (true) return CompareTo.LE;}
      break;
    case EQ:
      jj_consume_token(EQ);
               {if (true) return CompareTo.EQ;}
      break;
    case GE:
      jj_consume_token(GE);
               {if (true) return CompareTo.GE;}
      break;
    case GT:
      jj_consume_token(GT);
               {if (true) return CompareTo.GT;}
      break;
    case NE:
      jj_consume_token(NE);
               {if (true) return CompareTo.NE;}
      break;
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*-------------------------------------------------+
| CONSTANTS                                        |
+-------------------------------------------------*/
  final public Constant constant() throws ParseException {
        Constant c;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_STRING:
      c = quoted_string();
                                {if (true) return c;}
      break;
    case QUOTED_CHAR:
      c = quoted_char();
                                {if (true) return c;}
      break;
    case INTEGER_LITERAL:
      c = integer_literal();
                                {if (true) return c;}
      break;
    case REAL_LITERAL:
      c = real_literal();
                                {if (true) return c;}
      break;
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public StringConstant quoted_string() throws ParseException {
        Token t;
    t = jj_consume_token(QUOTED_STRING);
                String st = t.image;
                st = st.substring(1, st.length() - 1);
                {if (true) return new StringConstant(st);}
    throw new Error("Missing return statement in function");
  }

  final public StringConstant quoted_char() throws ParseException {
        Token t;
    t = jj_consume_token(QUOTED_CHAR);
                String st = t.image;
                st = st.substring(1, st.length() - 1);
                {if (true) return new StringConstant(st);}
    throw new Error("Missing return statement in function");
  }

  final public IntegerConstant integer_literal() throws ParseException {
        Token t;
    t = jj_consume_token(INTEGER_LITERAL);
                int i = Integer.parseInt(t.image);
                {if (true) return new IntegerConstant(i);}
    throw new Error("Missing return statement in function");
  }

  final public RealConstant real_literal() throws ParseException {
        Token t;
    t = jj_consume_token(REAL_LITERAL);
                float f = Float.parseFloat(t.image);
                {if (true) return new RealConstant(f);}
    throw new Error("Missing return statement in function");
  }

  public RqlParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[41];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x80000,0x10000000,0xc3001000,0x0,0x8000000,0x80000,0x40000,0x0,0x80000,0xc0004000,0xc0000000,0x100000,0x4000,0xc0000000,0x4000,0x4000,0x0,0x200000,0x0,0x1000000,0x1000000,0x40000000,0x40000000,0x1000000,0xc1000000,0x1000000,0x1000000,0x80000000,0x80000000,0x1000000,0x1000000,0xc3000000,0x200000,0x10000,0x0,0x0,0x0,0xc3001000,0x7e0,0x7e0,0x0,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x2070007f,0x700000,0x0,0x0,0x2078007f,0x2078007f,0x0,0x2060007f,0x0,0x0,0x0,0x2060007f,0x0,0x0,0x100000,0x0,0x20200000,0x20100000,0x100000,0x20200067,0x200067,0x0,0x2070007f,0x0,0x0,0x20400018,0x400018,0x0,0x0,0x27f0007f,0x0,0x0,0x70000,0x400,0x200,0x27f069ff,0x9000,0x0,0x7800000,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }

  public RqlParser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new RqlParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  public RqlParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new RqlParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  public RqlParser(RqlParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  public void ReInit(RqlParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[71];
    for (int i = 0; i < 71; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 41; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 71; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
