/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.query.rql.model;

import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;

public abstract class Var implements ResourceQuery {

	protected String _name;

	// not accessible from outside, must use get/set methods!
	private Value _value;

	/** Used for implicit joins between vars. **/
	protected Var _leader = null;


	public Var(String name) {
		_name = name;
	}

	public String getQuery() {
		return _name;
	}

	public String getName() {
		return _name;
	}

	public void setValue(Value value) {
//System.out.println(_name + " := " + value);
		if (_leader == null) {
			_value = value;
		}
		else {
			_leader.setValue(value);
		}
	}

	public Value getValue() {
		if (_leader == null) {
			return _value;
		}
		else {
			return _leader.getValue();
		}
	}

	public boolean hasValue() {
		return getValue() != null;
	}

	public void setLeader(Var leader) {
		_leader = leader;
	}

	public Var getLeader() {
		return _leader;
	}

	public boolean hasLeader() {
		return _leader != null;
	}

	public boolean returnsSet() {
		return false;
	}

	public String toString() {
		StringBuffer result = new StringBuffer();
		result.append(_name);
		if (_leader != null) {
			result.append("[-->");
			result.append(_leader);
			result.append("]");
		}
		else if (_value != null) {
			result.append("[");
            if (_value instanceof org.openrdf.model.URI) {
                result.append(((org.openrdf.model.URI)_value).getURI());
            }
            else if (_value instanceof BNode) {
                result.append(((BNode)_value).getID());
            }
			else if (_value instanceof Literal) {
                result.append(((Literal)_value).getLabel());
            }
            else {
                result.append("SET");
            }
			result.append("]");
		}
		return result.toString();
	}
}
