/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.query.rql.model;

import org.openrdf.model.Resource;

import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.sail.RdfSchemaSource;

/** 
 * UnknownSelector is a preprocessing object which is necessary because
 * it is not always possible at parsing time to decide whether a path
 * expresion is a InstanceSelector or a DataPathSelector. This happens
 * when a path expression of the form "url{VAR}" is encountered.
 **/
public class UnknownSelector implements Selector {

	protected DataVar _var;

	protected URI _uri;

	protected Selector _selector = null;

	public UnknownSelector(URI uri, DataVar var) {
		_uri = uri;
		_var = var;
	}

	/**
	 * Determines whether the selector is a <code>ResourceSelector</code>
	 * by checking whether the URI is a known Class.
	 **/
	public boolean isInstanceSelector(RdfSchemaSource rss) {
		Resource resource = (Resource)_uri.getValue();
		return rss.isClass(resource);
	}

	public void initialize(RdfSchemaSource rss)
		throws QueryEvaluationException
	{
		if (_selector == null) {
			if (rss.isClass((Resource)_uri.getValue())) {
				_selector = new InstanceSelector(_var, _uri);
			}
			else {
				DataVar sourceVar = new DataVar("_");
				PropertyVar propVar = new PropertyVar("_");
				propVar.setValue(_uri.getValue());

				// property was a uri, so use extended interpretation
				_selector = new DataPathSelector(sourceVar, propVar, _var, true);
			}
		}
		_selector.initialize(rss);
	}

	public boolean selectNext(RdfSchemaSource rss)
		throws QueryEvaluationException
	{
		return _selector.selectNext(rss);
	}

	public void clear() {
		if (_selector != null) {
			_selector.clear();
			_selector = null;
		}
	}

	public String toString() {
		String result = _uri.toString() + "{" + _var.toString() + "}";
		return result;
	}

}

