/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.query.rql.model;

import java.io.IOException;

import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.iterators.StatementSubjectIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.ValueIterator;

public class RdfProperty implements PropertyQuery {

	public RdfProperty() {
	}

	public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener)
		throws QueryEvaluationException
	{
		try {
			String columnHeader[] = {
				"Properties" };
			listener.startTableQueryResult(columnHeader);

			ResourceIterator iter = getProperties(rss);

			while (iter.hasNext()) {
				listener.startTuple();
				listener.tupleValue(iter.next());
				listener.endTuple();
			}
			iter.close();

			listener.endTableQueryResult();
		}
		catch (IOException e) {
			throw new QueryEvaluationException(e);
		}
	}

	public ValueIterator getResources(RdfSchemaSource rss) {
		return getProperties(rss);
	}

	public ResourceIterator getProperties(RdfSchemaSource rss) {
		return new StatementSubjectIterator(rss.getProperties());
	}

	public boolean returnsSet() {
		return true;
	}

	public String getQuery() {
		return "Property";
	}

	public String toString() {
		return "Property";
	}
}
