/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.query.rql.model;

import org.openrdf.model.GraphException;
import org.openrdf.model.Value;

import org.openrdf.sesame.sail.StatementIterator;

/**
 * An object structure representing an instantiation of a select-clause.
 *
 * @author Jeen Broekstra
 * @version $Revision: 1.6.4.2 $
 */
public class Projection implements Value {

	protected Value[] _values;
	protected int _position, _size;

	public Projection(int size) {
		_values = new Value[size];
		_position = 0;
		_size = size;
	}

	public void add(Value val) 
		throws IndexOutOfBoundsException 
	{
		_values[_position] = val;
		_position++;
	}

	/* may return null for unitialized values (null tokens) */
	public Value get(int position)
		throws IndexOutOfBoundsException 
	{
		return _values[position];
	}

	public int size() {
		return _size;
	}

	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (other instanceof Projection) {
			Projection oProj = (Projection)other;
			if (_size == oProj.size()) {
				Value oVal;
				for (int i = 0; i < _size; i++) {
					oVal = oProj.get(i);
					if (_values[i] != null) { 
						if (! _values[i].equals(oVal)) {
							return false;
						}
					}
					else if (oVal != null) { 
						return false;
					}
				}
				return true;
			}
		}
		return false;
	}

	public int hashCode() {
		if (_values.length > 0) {
			if (_values[0] != null) {
				return _values[0].hashCode();
			}
		}
		return 42;
	}

	public int compareTo(Object o) {
		Projection other = (Projection)o;

		int result = size() - other.size();

		if (result == 0) {
			// Projections have equal size

			for (int i = 0; i < size() && result == 0; i++) {
				Value thisValue = get(i);
				Value otherValue = other.get(i);

				result = thisValue.compareTo(otherValue);
			}
		}

		return result;
	}

	/* (non-Javadoc)
	 * @see org.openrdf.model.Value#getObjectStatements()
	 */
	public StatementIterator getObjectStatements() throws GraphException {
		throw new GraphException("no backing store associated");
	}
}
