/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.query.rql.model;

import org.openrdf.model.Value;

import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ValueIterator;

public class Exists implements BooleanQuery {

	protected Var _var;

	protected ResourceQuery _query;

	protected BooleanQuery _condition;

	public Exists(Var var, ResourceQuery query, BooleanQuery condition) {
		_var = var;
		_query = query;
		_condition = condition;
	}

	public boolean isTrue(RdfSchemaSource rss)
		throws QueryEvaluationException
	{
		ValueIterator iter = _query.getResources(rss);

		Value value;
		while (iter.hasNext()) {
			value = iter.next();
			_var.setValue(value);
			if (_condition.isTrue(rss)) {
				// Close iterator
				iter.close();
				_var.setValue(null);
				return true;
			}
		}

		_var.setValue(null);
		return false;
	}

	public String getQuery() {
		return this.toString();
	}

	public String toString() {
		StringBuffer result = new StringBuffer();

		result.append("exists ");
		result.append(_var.toString());
		result.append(" ");
		result.append(_query.toString());
		result.append(" : ");
		result.append(_condition.toString());

		return result.toString();
	}
}
