/* Generated By:JavaCC: Do not edit this line. RdqlParser.java */
package org.openrdf.sesame.query.rdql.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.openrdf.util.xml.XmlDatatypeUtil;
import org.openrdf.vocabulary.OWL;
import org.openrdf.vocabulary.RDF;
import org.openrdf.vocabulary.RDFS;
import org.openrdf.vocabulary.XmlSchema;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;

import org.openrdf.rio.ntriples.NTriplesUtil;

import org.openrdf.sesame.query.TableQuery;
import org.openrdf.sesame.sail.query.And;
import org.openrdf.sesame.sail.query.BooleanConstant;
import org.openrdf.sesame.sail.query.BooleanExpr;
import org.openrdf.sesame.sail.query.GraphPattern;
import org.openrdf.sesame.sail.query.Like;
import org.openrdf.sesame.sail.query.LiteralExpr;
import org.openrdf.sesame.sail.query.MathExpr;
import org.openrdf.sesame.sail.query.Not;
import org.openrdf.sesame.sail.query.Null;
import org.openrdf.sesame.sail.query.Or;
import org.openrdf.sesame.sail.query.ProjectionElem;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.ResourceExpr;
import org.openrdf.sesame.sail.query.SelectQuery;
import org.openrdf.sesame.sail.query.StringCompare;
import org.openrdf.sesame.sail.query.StringConstant;
import org.openrdf.sesame.sail.query.TriplePattern;
import org.openrdf.sesame.sail.query.ValueCompare;
import org.openrdf.sesame.sail.query.ValueExpr;
import org.openrdf.sesame.sail.query.Var;

public class RdqlParser implements RdqlParserConstants {

/*----------+
| Constants |
+----------*/

        public static final URI XSD_INTEGER = new URIImpl(XmlSchema.INTEGER);
        public static final URI XSD_FLOAT = new URIImpl(XmlSchema.FLOAT);

/*----------+
| Variables |
+----------*/

        /**
	 * Mapping of prefix to namespace.
	 **/
        protected Map _namespaces = new HashMap(16);

        /**
	 * List of shared variables. Named variables are shared; multiple
	 * occurrences of the name of one variable in a query represent
	 * the same variable.
	 **/
        protected List _sharedVars = new ArrayList(16);

        /**
	 * Anonymous variable identifier.
	 **/
        protected int _varNo = 0;

/*-------------------------------+
| Methods                        |
+-------------------------------*/

        /**
	 * Adds a mapping from the specified prefix to the specified
	 * namespace. The specified prefix must already be mapped to some
	 * (other) namespace.
	 *
	 * @return true if the mapping has been added, false otherwise.
	 * @exception ParseException If the specified prefix is already
	 * mapped to some (other) namespace.
	 **/
        protected void _setNamespacePrefix(String prefix, String namespace)
                throws ParseException
        {
                if (_namespaces.containsKey(prefix)) {
                        // Prefix already defined, report this error.
                        throw new ParseException("Prefix \"" + prefix + "\" already in use.");
                }

                _namespaces.put(prefix, namespace);
        }

        /**
	 * Gets the namespace that is mapped to the supplied prefix.
	 **/
        protected String _getNamespace(String prefix) {
                String result = (String)_namespaces.get(prefix);

                // rdf, rdfs, xsd and owl are default
                // namespace when not defined explicitly.
                if (result == null) {
                        if ("rdf".equals(prefix)) {
                                result = RDF.NAMESPACE;
                        }
                        else if ("rdfs".equals(prefix)) {
                                result = RDFS.NAMESPACE;
                        }
                        else if ("xsd".equals(prefix)) {
                                result = XmlSchema.NAMESPACE;
                        }
                        else if ("owl".equals(prefix)) {
                                result = OWL.NAMESPACE;
                        }
                }

                return result;
        }

        /**
	 * Returns the shared instance of Var that is associated with the
	 * specified variable name. A new shared variable will be created
	 * whenever this method is called with a new variable name.
	 **/
        protected Var _getSharedVar(String varName) {
                Var var;

                // Search for a variable with the supplied name in _sharedVars
                Iterator i = _sharedVars.iterator();
                while (i.hasNext()) {
                        var = (Var)i.next();
                        if (var.getName().equals(varName)) {
                                // Variable found
                                return var;
                        }
                }

                // Variable does not exist; create one and add it to a number of lists
                var = new Var(varName);
                _sharedVars.add(var);

                return var;
        }

        /**
	 * Creates a new anonymous variable and returns it.
	 **/
        protected Var _createAnonymousVar() {
                Var result = new Var("_" + _varNo++);
                result.setAnonymous(true);
                return result;
        }

        /**
	 * Parses a string representating of full or abbreviated URI and
	 * creates a URI object from it.
	 **/
        protected URI _parseURI(String uri)
                throws ParseException
        {
                if (uri.startsWith("<")) {
                        return _parseQuotedURI(uri);
                }
                else {
                        return _parseQName(uri);
                }
        }

        /**
	 * Parses a quoted URI (i.e. <tt>&lt;http://foo/bar&gt;</tt>) and creates a
	 * URI object for it.
	 **/
        protected URI _parseQuotedURI(String uri)
                throws ParseException
        {
                // Full URI starts with "<" and ends with ">", remove these characters.
                try {
                        uri = uri.substring(1, uri.length() - 1);

                        // Substitute any prefixes with their associated namespace
                        int colonIdx = uri.indexOf(':');
                        if (colonIdx > 0) {
                                String prefix = uri.substring(0, colonIdx);
                                String localName = uri.substring(colonIdx + 1);

                                String namespace = _getNamespace(prefix);

                                if (namespace != null) {
                                        // Rebuild URI using namespace and localname
                                        uri = namespace + localName;
                                }
                        }

                        return new URIImpl(uri);
                }
                catch (IllegalArgumentException e) {
                        // Not a valid, fully qualified URI
                        throw new ParseException(e.getMessage());
                }
        }

        /**
	 * Parses a string representing an abbreviated URI (i.e.
	 * <tt>rdf:type</tt>) and creates a URI object for it.
	 **/
        protected URI _parseQName(String uri)
                throws ParseException
        {
                // QNames have the form PREFIX:LNAME, substitute the PREFIX
                // with an actual namespace.

                int colonIdx = uri.indexOf(':');

                String prefix = uri.substring(0, colonIdx);
                String localName = uri.substring(colonIdx + 1);

                String namespace = _getNamespace(prefix);

                if (namespace == null) {
                        throw new ParseException("Prefix \"" + prefix + "\" not defined.");
                }

                return new URIImpl(namespace + localName);
        }

        /**
	 * Parses a new Literal from the supplied String.
	 **/
        protected Literal _parseLiteral(String literal)
                throws ParseException
        {
                // Find string separation points
                int endLabelIdx = _findEndOfLabel(literal);
                int startLangIdx = literal.indexOf("@", endLabelIdx);
                int startDtIdx = literal.indexOf("^^", Math.max(endLabelIdx, startLangIdx));

                // Get label
                String label = literal.substring(1, endLabelIdx);
                label = NTriplesUtil.unescapeString(label);

                if (startLangIdx != -1) {
                        // Get language
                        String language = literal.substring(startLangIdx + 1);
                        return new LiteralImpl(label, language);
                }
                else if (startDtIdx != -1) {
                        // Get datatype
                        String dtString = literal.substring(startDtIdx + 2);
                        URI datatype = _parseURI(dtString);

                        // Normalize label when datatype is XML Schema built-in
                        if (XmlDatatypeUtil.isBuiltInDatatype(datatype.getURI())) {
                                try {
                                        label = XmlDatatypeUtil.normalize(label, datatype.getURI());
                                }
                                catch (IllegalArgumentException e) {
                                        throw new ParseException(e.getMessage());
                                }
                        }

                        return new LiteralImpl(label, datatype);
                }
                else {
                        return new LiteralImpl(label);
                }
        }

        /**
	 * Finds the end of the label in a literal string. This method
	 * takes into account that characters can be escaped using
	 * backslashes.
	 *
	 * @return The index of the double quote ending the label.
	 **/
        private int _findEndOfLabel(String literal)
                throws ParseException
        {
                // First character of literal is guaranteed to be a double
                // quote, start search at second character.

                boolean previousWasBackslash = false;

                for (int i = 1; i < literal.length(); i++) {
                        char c = literal.charAt(i);

                        if (c == '"' && !previousWasBackslash) {
                                return i;
                        }
                        else if (c == '\\' && !previousWasBackslash) {
                                // start of escape
                                previousWasBackslash = true;
                        }
                        else if (previousWasBackslash) {
                                // c was escaped
                                previousWasBackslash = false;
                        }
                }

                throw new ParseException("Could not find end of literal label");
        }

        /**
	 * Creates a new ParseException with the supplied current and
	 * expected tokens. See ParseException for details.
	 **/
        protected ParseException _createParseException(
                Token currentTokenVal, String[] tokenImage)
        {
                // Append "<EOF>" in front of the supplied String array.
                // ParseException.getMessage expects "<EOF>" as the first String
                // in the String array.
                int length = tokenImage.length;

                // New String array has one element extra, therefore length of
                // new String array is increased by one.
                String[] newTokenImage = new String[length + 1];

                // First element is "<EOF>"
                newTokenImage[0] = "<EOF>";

                // Copy Strings of the supplied String array to the new String array.
                for (int i = 0; i < length; i++) {
                        newTokenImage[i +1] = tokenImage[i];
                }

                int[][] expectedTokenSequences = new int[1][length];

                for (int i = 0; i < length; i++) {
                        expectedTokenSequences [0][i] = i +1;
                }

                return new ParseException(currentTokenVal, expectedTokenSequences, newTokenImage);
        }

  final public TableQuery parseQuery() throws ParseException {
        Query qc;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PREFIXES:
      prefixes_clause();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    qc = select_query();
    jj_consume_token(0);
                        {if (true) return new TableQuery(qc);}
    throw new Error("Missing return statement in function");
  }

  final public void comma_opt() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
  }

/*-------------------------------+
| NAMESPACE DECLARATIONS         |
+-------------------------------*/
  final public void prefixes_clause() throws ParseException {
    jj_consume_token(PREFIXES);
    prefix_decl();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
      case NCNAME:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_1;
      }
      comma_opt();
      prefix_decl();
    }
  }

  final public void prefix_decl() throws ParseException {
        Token prefixToken;
        ResourceExpr uri;
    prefixToken = jj_consume_token(NCNAME);
    jj_consume_token(FOR);
    uri = quoted_uri();
                        String prefix = prefixToken.image;
                        _setNamespacePrefix(prefix, uri.getString());
  }

  final public Query select_query() throws ParseException {
        List projection;
        GraphPattern graphPattern = new GraphPattern();
    jj_consume_token(SELECT);
    projection = projection();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SOURCE:
    case FROM:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SOURCE:
        jj_consume_token(SOURCE);
        break;
      case FROM:
        jj_consume_token(FROM);
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(QUOTED_URI);
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
        case QUOTED_URI:
          ;
          break;
        default:
          jj_la1[4] = jj_gen;
          break label_2;
        }
        comma_opt();
        jj_consume_token(QUOTED_URI);
      }
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    jj_consume_token(WHERE);
    triple_pattern_clause(graphPattern);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUCHTHAT:
      jj_consume_token(SUCHTHAT);
      constraint_clause(graphPattern);
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
                        if (projection == null) {
                                // "SELECT *", take all shared variables
                                projection = new ArrayList(_sharedVars.size());
                                for (int i = 0; i < _sharedVars.size(); i++) {
                                        Var var = (Var)_sharedVars.get(i);
                                        projection.add( new ProjectionElem(var, null) );
                                }
                        }

                        if (projection.isEmpty()) {
                                {if (true) throw new ParseException("Select clause does not contain any variables.");}
                        }

                        {if (true) return new SelectQuery(projection, graphPattern);}
    throw new Error("Missing return statement in function");
  }

  final public List projection() throws ParseException {
        Var var;
        List projection;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
                 {if (true) return null;}
      break;
    case VAR:
          projection = new ArrayList(16);
      var = var();
                       projection.add( new ProjectionElem(var) );
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
        case VAR:
          ;
          break;
        default:
          jj_la1[7] = jj_gen;
          break label_3;
        }
        comma_opt();
        var = var();
                                           projection.add( new ProjectionElem(var) );
      }
                        {if (true) return projection;}
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ProjectionElem projection_elem() throws ParseException {
        Var var;
    var = var();
                {if (true) return new ProjectionElem(var);}
    throw new Error("Missing return statement in function");
  }

  final public void triple_pattern_clause(GraphPattern graphPattern) throws ParseException {
    triple_pattern(graphPattern);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
      case LPAREN:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_4;
      }
      comma_opt();
      triple_pattern(graphPattern);
    }
  }

  final public void triple_pattern(GraphPattern graphPattern) throws ParseException {
        ValueExpr subject, predicate, object;
        Var subjectVar, predicateVar, objectVar;
    jj_consume_token(LPAREN);
    subject = var_or_uri();
    comma_opt();
    predicate = var_or_uri();
    comma_opt();
    object = var_or_const();
    jj_consume_token(RPAREN);
                        if (subject instanceof Var) {
                                subjectVar = (Var)subject;
                        }
                        else {
                                subjectVar = _createAnonymousVar();
                                subjectVar.setValue( subject.getValue() );
                        }

                        if (predicate instanceof Var) {
                                predicateVar = (Var)predicate;
                        }
                        else {
                                predicateVar = _createAnonymousVar();
                                predicateVar.setValue( predicate.getValue() );
                        }

                        if (object instanceof Var) {
                                objectVar = (Var)object;
                        }
                        else {
                                objectVar = _createAnonymousVar();
                                objectVar.setValue( object.getValue() );
                        }

                        graphPattern.add( new TriplePattern(subjectVar, predicateVar, objectVar) );
  }

  final public void constraint_clause(GraphPattern graphPattern) throws ParseException {
        BooleanExpr boolExpr;
    boolExpr = boolean_expr();
                                    graphPattern.addConstraint(boolExpr);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
      case SUCHTHAT:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        break;
      case SUCHTHAT:
        jj_consume_token(SUCHTHAT);
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      boolExpr = boolean_expr();
                                            graphPattern.addConstraint(boolExpr);
    }
  }

  final public BooleanExpr boolean_expr() throws ParseException {
        BooleanExpr result, tmpExpr;
    result = conditional_and_expr();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SC_OR:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_6;
      }
      jj_consume_token(SC_OR);
      tmpExpr = conditional_and_expr();
                                result = new Or(result, tmpExpr);
    }
                        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public BooleanExpr conditional_and_expr() throws ParseException {
        BooleanExpr result, tmpExpr;
    result = boolean_elem();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SC_AND:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_7;
      }
      jj_consume_token(SC_AND);
      tmpExpr = boolean_elem();
                                result = new And(result, tmpExpr);
    }
                        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public BooleanExpr boolean_elem() throws ParseException {
        ValueExpr leftValue, rightValue;
        BooleanExpr expr;
        int op;
        String pattern;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
                {if (true) return BooleanConstant.TRUE;}
      break;
    case FALSE:
      jj_consume_token(FALSE);
                {if (true) return BooleanConstant.FALSE;}
      break;
    default:
      jj_la1[15] = jj_gen;
      if (jj_2_1(5)) {
        jj_consume_token(LPAREN);
        expr = boolean_expr();
        jj_consume_token(RPAREN);
                {if (true) return expr;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NOT:
          jj_consume_token(NOT);
          expr = boolean_elem();
                {if (true) return new Not(expr);}
          break;
        case PLUS:
        case MINUS:
        case LPAREN:
        case NULL:
        case TEXT_LITERAL:
        case QUOTED_URI:
        case QNAME:
        case VAR:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
          leftValue = value_expr();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STR_EQ:
          case STR_NE:
            op = string_compare_operator();
            rightValue = value_expr();
                                {if (true) return new StringCompare(leftValue, rightValue, op);}
            break;
          case EQ:
          case NE:
          case LT:
          case LE:
          case GE:
          case GT:
            op = value_compare_operator();
            rightValue = value_expr();
                                {if (true) return new ValueCompare(leftValue, rightValue, op);}
            break;
          case STR_MATCH:
            jj_consume_token(STR_MATCH);
            pattern = string();
                                {if (true) return new Like(leftValue, new StringConstant(pattern), true);}
            break;
          case STR_NMATCH:
            jj_consume_token(STR_NMATCH);
            pattern = string();
                                {if (true) return new Not( new Like(leftValue, new StringConstant(pattern), true) );}
            break;
          default:
            jj_la1[14] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[16] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public int string_compare_operator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STR_EQ:
      jj_consume_token(STR_EQ);
                   {if (true) return StringCompare.EQ;}
      break;
    case STR_NE:
      jj_consume_token(STR_NE);
                   {if (true) return StringCompare.NE;}
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int value_compare_operator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      jj_consume_token(EQ);
               {if (true) return ValueCompare.EQ;}
      break;
    case NE:
      jj_consume_token(NE);
               {if (true) return ValueCompare.NE;}
      break;
    case LT:
      jj_consume_token(LT);
               {if (true) return ValueCompare.LT;}
      break;
    case LE:
      jj_consume_token(LE);
               {if (true) return ValueCompare.LE;}
      break;
    case GE:
      jj_consume_token(GE);
               {if (true) return ValueCompare.GE;}
      break;
    case GT:
      jj_consume_token(GT);
               {if (true) return ValueCompare.GT;}
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueExpr value_expr() throws ParseException {
        ValueExpr result;
    result = additive_expr();
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public ValueExpr additive_expr() throws ParseException {
        ValueExpr result, tmpExpr;
        int op;
    result = multiplicative_expr();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[19] = jj_gen;
        break label_8;
      }
      op = additive_operator();
      tmpExpr = multiplicative_expr();
                        result = new MathExpr(result, tmpExpr, op);
    }
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public int additive_operator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
                  {if (true) return MathExpr.PLUS;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
                  {if (true) return MathExpr.SUBTRACT;}
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueExpr multiplicative_expr() throws ParseException {
        ValueExpr result, tmpExpr;
        int op;
    result = unary_expr();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
      case SLASH:
      case REM:
        ;
        break;
      default:
        jj_la1[21] = jj_gen;
        break label_9;
      }
      op = multiplicative_operator();
      tmpExpr = unary_expr();
                        result = new MathExpr(result, tmpExpr, op);
    }
                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public int multiplicative_operator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
                  {if (true) return MathExpr.MULTIPLY;}
      break;
    case SLASH:
      jj_consume_token(SLASH);
                  {if (true) return MathExpr.DIVIDE;}
      break;
    case REM:
      jj_consume_token(REM);
                  {if (true) return MathExpr.REMAINDER;}
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueExpr unary_expr() throws ParseException {
        ValueExpr result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
    case TEXT_LITERAL:
    case QUOTED_URI:
    case QNAME:
    case VAR:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
      result = var_or_const();
                {if (true) return result;}
      break;
    case PLUS:
      jj_consume_token(PLUS);
      result = unary_expr();
                {if (true) return result;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
      result = unary_expr();
                // Multiply by -1
                {if (true) return new MathExpr(
                                new LiteralExpr( new LiteralImpl("-1", XSD_INTEGER) ), // -1
                                result, MathExpr.MULTIPLY);}
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      result = unary_expr();
      jj_consume_token(RPAREN);
                {if (true) return result;}
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueExpr var_or_uri() throws ParseException {
        ValueExpr result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VAR:
      result = var();
                         {if (true) return result;}
      break;
    case QUOTED_URI:
    case QNAME:
      result = uri();
                         {if (true) return result;}
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ValueExpr var_or_const() throws ParseException {
        ValueExpr result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VAR:
      result = var();
                             {if (true) return result;}
      break;
    case NULL:
    case TEXT_LITERAL:
    case QUOTED_URI:
    case QNAME:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
      result = value();
                             {if (true) return result;}
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Var var() throws ParseException {
        Token varToken;
    varToken = jj_consume_token(VAR);
                String varName = varToken.image.substring(1);
                {if (true) return _getSharedVar(varName);}
    throw new Error("Missing return statement in function");
  }

  final public ValueExpr value() throws ParseException {
        ValueExpr result;
        Var var;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_URI:
    case QNAME:
      result = uri();
                             {if (true) return result;}
      break;
    case TEXT_LITERAL:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
      result = literal();
                             {if (true) return result;}
      break;
    case NULL:
      result = _null();
                             {if (true) return result;}
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ResourceExpr uri() throws ParseException {
        ResourceExpr expr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTED_URI:
      expr = quoted_uri();
                              {if (true) return expr;}
      break;
    case QNAME:
      expr = qname();
                         {if (true) return expr;}
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ResourceExpr quoted_uri() throws ParseException {
        Token uriToken;
    uriToken = jj_consume_token(QUOTED_URI);
                URI uri = _parseQuotedURI(uriToken.image);
                {if (true) return new ResourceExpr(uri);}
    throw new Error("Missing return statement in function");
  }

  final public ResourceExpr qname() throws ParseException {
        Token uriToken;
    uriToken = jj_consume_token(QNAME);
                URI uri = _parseQName(uriToken.image);
                {if (true) return new ResourceExpr(uri);}
    throw new Error("Missing return statement in function");
  }

  final public LiteralExpr literal() throws ParseException {
        Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEXT_LITERAL:
      token = jj_consume_token(TEXT_LITERAL);
                        {if (true) return new LiteralExpr( _parseLiteral(token.image) );}
      break;
    case INTEGER_LITERAL:
      token = jj_consume_token(INTEGER_LITERAL);
                        {if (true) return new LiteralExpr( new LiteralImpl(
                                        XmlDatatypeUtil.normalizeInteger(token.image),
                                        XSD_INTEGER) );}
      break;
    case FLOATING_POINT_LITERAL:
      token = jj_consume_token(FLOATING_POINT_LITERAL);
                        {if (true) return new LiteralExpr( new LiteralImpl(
                                        XmlDatatypeUtil.normalizeFloat(token.image),
                                        XSD_FLOAT) );}
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String string() throws ParseException {
        Token token;
    try {
      token = jj_consume_token(TEXT_LITERAL);
    } catch (ParseException e) {
                // thrown exception reports that a <TEXT_LITERAL> is
                // expected, but we actually mean a <STRING>
                {if (true) throw _createParseException(e.currentToken, new String[]{"<STRING>"});}
    }
                        Literal literal = _parseLiteral(token.image);

                        if (literal.getLanguage() != null || literal.getDatatype() != null) {
                                // Not a plain literal that can be qualified as a string
                                {if (true) throw new ParseException("Expected <STRING>, found <TEXT_LITERAL>: " + literal.toString());}
                        }

                        {if (true) return literal.getLabel();}
    throw new Error("Missing return statement in function");
  }

  final public Null _null() throws ParseException {
    jj_consume_token(NULL);
                 {if (true) return new Null();}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_3R_67() {
    if (jj_scan_token(QUOTED_URI)) return true;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  final private boolean jj_3R_45() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_3R_26()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_3R_45()) return true;
    if (jj_3R_38()) return true;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_3R_25()) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_3R_67()) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    }
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_3R_61()) return true;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_3R_38()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_39()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_3R_59()) return true;
    return false;
  }

  final private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_18() {
    if (jj_3R_19()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  final private boolean jj_3R_40() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) return true;
    }
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_10()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(VAR)) return true;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_3R_40()) return true;
    if (jj_3R_28()) return true;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_scan_token(TEXT_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3R_48() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    }
    return false;
  }

  final private boolean jj_3R_13() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_15()) {
    jj_scanpos = xsp;
    if (jj_3R_16()) {
    jj_scanpos = xsp;
    if (jj_3_1()) {
    jj_scanpos = xsp;
    if (jj_3R_17()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_3R_28()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_29()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_scan_token(SC_AND)) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_38()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_scan_token(TEXT_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3R_60() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_11() {
    if (jj_3R_13()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_14()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_38()) return true;
    return false;
  }

  final private boolean jj_3R_26() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  final private boolean jj_3R_12() {
    if (jj_scan_token(SC_OR)) return true;
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_38()) return true;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(STR_NE)) return true;
    return false;
  }

  final private boolean jj_3R_25() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) return true;
    }
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_scan_token(STR_EQ)) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_scan_token(QNAME)) return true;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_scan_token(STR_NMATCH)) return true;
    if (jj_3R_27()) return true;
    return false;
  }

  final private boolean jj_3R_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_3R_48()) return true;
    return false;
  }

  final private boolean jj_3R_10() {
    if (jj_3R_11()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_12()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_22() {
    if (jj_scan_token(STR_MATCH)) return true;
    if (jj_3R_27()) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_scan_token(REM)) return true;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_scan_token(SLASH)) return true;
    return false;
  }

  public RdqlParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[29];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0x4000000,0x4000000,0x0,0x4000000,0x0,0x0,0x4000000,0x100000,0x14000000,0x4000000,0x4000000,0x10000,0x20000,0x1803f00,0x0,0x100c4000,0x0,0x3f00,0xc0000,0xc0000,0x700000,0x700000,0x100c0000,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x20,0x0,0x8000000,0x6,0x1000000,0x6,0x10,0x4000000,0x4000000,0x0,0x10,0x10,0x0,0x0,0x180,0x600,0x7001800,0x180,0x0,0x0,0x0,0x0,0x0,0x7001800,0x7000000,0x7001800,0x3001800,0x3000000,0x1000,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x0,0x18,0x18,0x0,0x18,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[1];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public RdqlParser(java.io.InputStream stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new RdqlParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public RdqlParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new RdqlParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public RdqlParser(RdqlParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(RdqlParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 29; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[69];
    for (int i = 0; i < 69; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 29; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 69; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 1; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
