/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-13070  USA
 */
package org.openrdf.sesame.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.openrdf.model.Value;

/**
 * Represents a tuple of Values.
 *
 * @author Peter van 't Hof
 * @version $Revision: 1.4.4.2 $
 */
public class Tuple {

/*----------+
| Variables |
+----------*/
	protected List _values;

/*-------------+
| Constructors |
+-------------*/
	/**
	 * Creates a new Tuple.
	 */
	public Tuple() {
		_values = new ArrayList();
	}

/*--------+
| Methods |
+--------*/
	/**
	 * Adds the supplied Value to this Tuple.
	 *
	 * @param value Value to add.
	 */
	public void add(Value value) {
		_values.add(value);
	}

	/**
	 * Returns iterator over this Tuple.
	 *
	 * @return Iterator over this Tuple.
	 */
	public Iterator iterator() {
		return _values.iterator();
	}

	/**
	 * Indicates whether some other object is equal to this one.
	 *
	 * @param other Object to compare this Tuple to.
	 * @return True if this object is the same as the other argument; false
	 * otherwise.
	 */	
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		else if (!(other instanceof Tuple)) {
			return false;
		}
		else {
			return _values.equals(((Tuple)other)._values);
		}		
	}

	/** 
	 * Returns hash code for this Tuple.
	 *
	 * @return Hash code for this Tuple.
	 */
	public int hashCode() {
		int hashCode = 0;
		int size = _values.size();

		for (int i = 0; i < size; i++) {
			Object object = _values.get(i);

			if (object == null) {
				// Default value for null is 0xFFFFFFFF.
				hashCode ^= (0xFFFFFFFF << i);
			}
			else {
				hashCode ^= (object.hashCode() >> i);
			}
		}
		
		return hashCode;
	}

	/** 
	 * Returns String representation of this Tuple.
	 *
	 * @return String representation of this Tuple.
	 */
	public String toString() {
		return _values.toString();
	}
}
