/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.query;

import java.io.IOException;

import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.QueryAnswer;
import org.openrdf.sesame.sail.query.QueryAnswerListener;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.SailQueryException;

/**
 * A TableQuery is a query that produces a table of values as its result.
 **/
public class TableQuery {
	
/*----------+
| Variables |
+----------*/

	private Query _query;
		
/*-------------+
| Constructors |
+-------------*/

	/**
	 * Creates a new SfwQuery.
	 *
	 * @param query An object representing the actual query.
	 **/
	public TableQuery(Query query) {
		_query = query;
	}

/*--------+
| Methods |
+--------*/

	public Query getQuery() {
		return _query;
	}

	public void optimize(RdfSource source) {
		_query = source.optimizeQuery(_query);
	}
	
	public void evaluate(RdfSource rdfSource, TableQueryResultListener listener)
		throws QueryEvaluationException
	{
		try {
			listener.startTableQueryResult(_query.getColumnHeaders());
			_query.evaluate(rdfSource, new QAL2TQRL(listener));
			listener.endTableQueryResult();
		}
		catch (SailQueryException e) {
			throw new QueryEvaluationException(e);
		}
		catch (IOException e) {
			throw new QueryEvaluationException(e);
		}
	}

	public String toString() {
		return "TableQuery [" + super.toString() + "]";
	}

/*---------------------+
| Inner class QAL2TQRL |
+---------------------*/

	/**
	 * An adapter translating QueryAnswerListener (QAL) method calls to
	 * TableQueryResultListener (TQRL) method calls.
	 **/
	private static class QAL2TQRL implements QueryAnswerListener {

		private TableQueryResultListener _listener;

		/**
		 * Creates a new SfwQuery.
		 *
		 * @param listener A TableQueryResultListener.
		 **/
		public QAL2TQRL(TableQueryResultListener listener) {
			_listener = listener;
		}

		// implements QueryAnswerListener.queryAnswer(QueryAnswer)
		public boolean queryAnswer(QueryAnswer qa)
			throws IOException
		{
			_listener.startTuple();

			for (int i = 0; i < qa.getValueCount(); i++) {
				_listener.tupleValue( qa.getValue(i) );
			}

			_listener.endTuple();

			return true;
		}

		// implements QueryAnswerListener.clear()
		public void clear() {
		}
	}
}
