/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.query;

import org.openrdf.util.Enumeration;

/**
 * A type-safe enumeration class for query error types.
 *
 * @author Arjohn Kampman
 * @version $Revision: 1.5.4.2 $
 **/
public final class QueryErrorType extends Enumeration {

/*------------------+
| Static stuff      |
+------------------*/

	/**
	 * Constant used for identifying a malformed query error. 
	 **/
	public static final QueryErrorType MALFORMED_QUERY_ERROR =
			new QueryErrorType("MalformedQueryError");

	/**
	 * Constant used for identifying a query evaluation error. 
	 **/
	public static final QueryErrorType QUERY_EVALUATION_ERROR =
			new QueryErrorType("QueryEvaluationError");

	/**
	 * A QueryErrorType array containing all possible values.
	 **/
	static private QueryErrorType[] _values =
			new QueryErrorType[] { MALFORMED_QUERY_ERROR, QUERY_EVALUATION_ERROR };

	/**
	 * Returns a QueryErrorType constant for the specified value.
	 *
	 * @param value The String-representation of a QueryErrorType constant.
	 * @return A QueryErrorType object, or <tt>null</tt> if the specified value
	 * could not be resolved to a QueryErrorType object.
	 **/
	public static QueryErrorType forValue(String value) {
		return (QueryErrorType)_forValue(_values, value);
	}

/*------------------+
| Non-static stuff  |
+------------------*/

	/**
	 * Creates a new QueryErrorType object.
	 **/
	private QueryErrorType(String value) {
		super(value);
	}
}
