/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.query;

import java.io.IOException;

import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

/**
 * <p>
 * A listener for graph-like query results. The results are returned as
 * triples.
 * </p>
 **/
public interface GraphQueryResultListener {

	/** Indicates the start of a graph-like query result. **/
	public void startGraphQueryResult()
		throws IOException;

	/** Indicates the end of a graph-like query result. **/
	public void endGraphQueryResult()
		throws IOException;

	/**
	 * Reports a namespace and its (preferred) prefix that might be
	 * used in the query result. Namespaces will be reported before
	 * the start of the query result as much as possible to accomodate
	 * listeners that need these mapping beforehand (like an RDF/XML
	 * document writer).
	 **/
	public void namespace(String prefix, String name)
		throws IOException;

	/** Delivers the next triple in the query result. **/
	public void triple(Resource subj, URI pred, Value obj)
		throws IOException;

	/** Reports an error that has occurred during the query evaluation. **/
	public void reportError(String msg)
		throws IOException;
}
