/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.omm;

/**
 */
import java.util.HashMap;

public class SessionContext {

/*---------------------------------------+
| Class-specific variables               |
+---------------------------------------*/

	private static InheritableThreadLocal _threadLocal = new InheritableThreadLocal();

	private static HashMap _sessionContextMap = new HashMap();

/*---------------------------------------+
| Static methods                         |
+---------------------------------------*/

	public static void put(Object key, SessionContext context) {
		synchronized (_sessionContextMap) {
			_sessionContextMap.put(key, context);
		}
	}

	public static SessionContext get(Object key) {
		SessionContext result = null;

		synchronized (_sessionContextMap) {
			Object o = _sessionContextMap.get(key);

			if (o != null && o instanceof SessionContext) {
				result = (SessionContext)o;
			}
		}

		return result;
	}

	public static void remove(Object key) {
		//System.out.println("remove ("+key.toString()+")");
		_sessionContextMap.remove(key);
	}

	public static void setContext(SessionContext context) {
		synchronized (_threadLocal) {
			_threadLocal.set(context);
		}
	}

	public static SessionContext getContext() {
		return getContext(false);
	}

	public static SessionContext getContext(boolean create) {
		SessionContext result = null;

		synchronized (_threadLocal) {
			Object o = _threadLocal.get();

			if (o != null && o instanceof SessionContext) {
				result = (SessionContext)o;
			}
			else if (create == true) {
				result = new SessionContext();
				setContext(result);
			}
		}

		return result;
	}

/*---------------------------------------+
| Object-specific variables              |
+---------------------------------------*/

	public int VersionState = -1;
	public String user = "";
	public String pass = "";
	public String repository = "";
	public String fullname = "";
	public boolean bLogged = false;
	public int userID = 0;
	public String baseUrl = "";
	public boolean bIncrementIsPaused = false;

	public final static int REINIT_MODE = 0;
	public final static int INCREMENTAL_MODE = 1;
	public final static int ADAPTIVE_MODE = 2;
	public int updateMode = ADAPTIVE_MODE;

	public SessionContext() {
	}
}
