/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.omm;

/**
 * Title:        OTK: SAIL interface definitions
 * Description:  This code is a part of OnTo-Knowledge project.
 * Company:      Sirma AI - OntoText Lab.
 * @author Damyan Ognyanoff
 * @version 1.0
 */

import org.openrdf.sesame.sail.Sail;

/**
 * Interface Reasoner provides the basic DL oprations that can be run
 * over the data held in the repository. The arguments of the methods are
 * classes from the HP library Jena v1.3.0 that can be found at
 * <A href="http://www.hpl.hp.com/semweb">http://www.hpl.hp.com/semweb<A>
 * especially <b>com.hp.hpl.jena.daml</b> package that provides DAML+OIL convenience
 * support. We plan to use only the interface part in to tie it with the
 * appropriate implemntation accoring to the RDF storage of the SEASAME.
 */
public interface Reasoner extends Sail {
//
//  /**
//   * Add a new DAML element to the repository.
//   * @param damlElement to add
//   * @returns true if the element was successfully added to the repository,
//   * otherwise false. The element could be rejected if it makes the repository
//   * inconsistent. This has to be an option. The repository is changed to a new state
//   */
//  public boolean tell(DAMLCommon damlElement);
//
//  /**
//   * Initiates classification of the repository
//   */
//  public void classify();
//
//  /**
//   * creates an empty repository
//   */
//  public void initialization();
//
//  /**
//   * Delete a DAML element form the repository.
//   * @param amlElemet to remove
//   * @returns true if the DAML element is successfully deleted from the repository,
//   * otherwise false. The repository is changed to a new state
//   *
//   * NOTE: Here we assume that what is deleted is a DAML+OIL element and its
//   * interpretation is unique with the repository. Only elements that where
//   * explicit added to the repository by the user could be deleted.
//   */
//  public boolean delete(DAMLCommon damlElement);
//
//  /**
//   * Retrieve a list of class names(resources) which are direct super clasess of
//   * a DAML class
//   * @param damlClass for which to retrive its direct super classes
//   * @returns a list of class names (resources) which are a direct super classes
//   */
//  public Iterator direct_supers_c(DAMLClass damlClass);
//
//  /**
//   * Retrieve a list of class names(resources) of all super clasess of a DAML class
//   * @param damlClass for which to retrive all its super classes
//   * @returns a list of class names (resources) ClassList which are
//   * a super classes
//   */
//  public Iterator all_supers_c(DAMLClass damlClass);
//
//  /**
//   * Retrieve a list of class names(resources) which are direct sub clasess of a DAML class
//   * @param damlClass for which to retrive its direct dub classes
//   * @returns a list of class names (resources) ClassList which are a direct
//   * sub classes
//   */
//  public Iterator direct_subs_c(DAMLClass damlClass);
//
//  /**
//   * Retrieve a list of class names(resources) of all sub clasess of a DAML class
//   * @param damlClass for which to retrive all its sub classes
//   * @returns a list of class names (resources) ClassList which are
//   * a sub classes
//   */
//  public Iterator all_subs_c(DAMLClass damlClass);
//
//  /**
//   * Retrieve a list of the most general classes defined in the
//   * repository. This operation can be defined using others, but sometimes is
//   * more convinient to have it explicitly defined
//   * @returns a list of all top classes
//   */
//  public Iterator top_c();
//
//  /**
//   * Retrieve a lis of all equivalent classes
//   * @param damlClass to query
//   * @returns a list of the names of the classes equivalent to the damlClass.
//   */
//  public Iterator equivalent_c(DAMLClass damlClass);
//
//  /**
//   * Retrieve a list of property names(resources) which are direct super properties of a
//   * DAML property
//   * @param damlProperty for which to retrive its direct super properties
//   * @returns a list of proprty names(resources)
//   */
//  public Iterator direct_supers_p(DAMLProperty damlProperty);
//
//  /**
//   * Retrieve a list of property names(resources) of all super properties of a
//   * DAML property
//   * @param damlProperty for which to retrive its super properties
//   * @returns a list of proprty names(resources)
//   */
//  public Iterator all_supers_p(DAMLProperty damlProperty);
//
//  /**
//   * Retrieve a list of property names(resources) which are direct sub properties of a
//   * DAML property
//   * @param damlProperty for which to retrive its direct sub properties
//   * @returns a list of proprty names(resources)
//   */
//  public Iterator direct_subs_p(DAMLProperty damlProperty);
//
//  /**
//   * Retrieve a list of property names(resources) of all sub properties of a
//   * DAML property
//   * @param damlProperty for which to retrive its sub properties
//   * @returns a list of proprty names(resources)
//   */
//  public Iterator all_subs_p(DAMLProperty damlProperty);
//
//  /**
//   * Retrieve a three lists of class names(resources): direct supre classes,
//   * direct sub classes and all equivalend classes of a DAML class
//   * @param damlClass for which to retrive these lists
//   * @returns a iterator to these lists
//   */
//  public Iterator taxonomy_position(DAMLClass damlClass);
//
//  /**
//   * Check if DAML class is statisfiable
//   * @param DAML class to check
//   * @return true if it is a satisfiable and false othewise
//   */
//  public boolean satisfiable(DAMLClass damlClass);
//
//  /**
//   * Check for subsumtion of two DAML classes.
//   * @param damlClass1
//   * @param damlClass2
//   * @returns true if the damlClass1 is subsumed by damlClass2 and false otherwise
//   */
//  public boolean subsumes(DAMLClass damlClass1, DAMLClass damlClass2);
//
//  /**
//   * Check for eqivalens of teo damlClasses
//   * @param damlClass1
//   * @param damlClass2
//   * @returns true if the damlClass1 is equivalent to damlClass2 and false otherwise
//   */
//  public boolean equivalent(DAMLClass damlClass1, DAMLClass damlClass2);
//
//  /**
//   * Perform consistency check of the repository
//   * @returns true if the repository has a model and false otherwise. Here
//   * different inferences will be performed on the base of the DAML elements.
//   * presented in the repository
//   */
//  public boolean consistent();
//
//  /**
//   * @param instanceList
//   * @returns a list of class names containing the classes describing
//   * all of the instances in the instanceList if such exist and empty list otherwise.
//   * This is a small generalisation over the realization defined in the above section.
//   * If the instanceList contains only one element then it is exactly the case
//   * described above. If the list contains more than one element then
//   * the result is a list of the more specific classes that describe all instances
//   * in the list. If we follow the idea of supporting English English and American
//   * English spelling we have to introduce a corresponding 'realization' method
//   */
//  public Iterator realisation(Iterator instanceList);
//
//  /**
//   * @param damlClass
//   * @returns a list of instance names containing the instances that are
//   * described by damlClass if such exist and empty list otherwise
//   */
//  public Iterator retrival(DAMLClass damlClass);
//
//  /**
//   * @param damlClass
//   * @returns a list of graphs representing the componets of each instance
//   * described by the damlClass. Each single component is a list of properies
//   * that connects the instance with some oteher with fixed length.
//   */
//  public Iterator retrival_components(DAMLClass damlClass);
//
//  /**
//   * Perform model chacking of the repository
//   * @returns true if teh dataset part of the repository is a model of ontological
//   * part of it, otherwise false.
//   */
//  public boolean model_checking();
//
//  /**
//   * Minimal ontolofy extraction.
//   * @returns a list of DAML+OIL elements (classes and properties) that the dataset
//   * part of the repository. The information in the headers is not extracted.
//   */
//  public Iterator ontology_extraction();
//
//  // display interfaces
//  /**
//   * @returns a list of all DAML class names used in the repository
//   */
//  public Iterator classes();
//
//  /**
//   * @returns a list of all DAML property names used in the repository
//   */
//  public Iterator properties();
//
//  /**
//   * @returns a list of all instance names used in the repository
//   */
//  public Iterator instances();
//
//  /**
//   * @returns a list of all literals used in the repository
//   */
//  public Iterator literals();
//
//  /**
//   * @returns a list of all resources used in the repository
//   */
//  public Iterator resources();
//
//  /**
//   * @returns a list of all class elements used in the repository
//   */
//  public Iterator class_elements();
//
//  /**
//   * @returns a list of all property elements used in the repository
//   */
//  public Iterator property_elements();
//
//  /**
//   * @returns a list of all instance elements used in the repository
//   */
//  public Iterator instance_elements();
//
//  /**
//   * @param Value to query
//   * @returns a list of all statements in the repository which use the Value.
//   * The Value can be resource or a literal.
//   */
//  public Iterator elements(String aValue);///???
} // interface Reasoner
