/*  OMM - Ontology Middleware Module
 *  Copyright (C) 2002 OntoText Lab, Sirma AI OOD
 *
 *  Contact:
 *	Sirma AI OOD, OntoText Lab.
 *	38A, Christo Botev Blvd.
 *  1000 Sofia, Bulgaria
 *	tel. +359(2)981 00 18
 *	fax. +359(2)981 90 58
 *	info@ontotext.com
 *
 * 	http://www.ontotext.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.openrdf.sesame.omm;

/**
 * Title:        OTK: SAIL interface definitions
 * Description:  This code is a part of OnTo-Knowledge project.
 * Company:      Sirma AI - OntoText Lab.
 * @author Damyan Ognyanoff
 * @version 1.0
 */

/**
 * The interface KCS is an entry point to access the rest of the
 * Ontology Middleware Module interfaces. The first method that should be called is
 * 'authenticate'.
 */
public interface KCS {
  /**
   * Perform a user authentication
   * @param userID
   * @param password password
   * @return true if user can access the repository
   *
   * NOTE: this is an entry point for the requested operation. When authentication
   * is performed the user permisisons are retrieved and used while
   * the request is processed.
   */
  boolean authenticate(String userID, String password);

  /**
   * Access the SecurityServices intrface.
   * @return SecurityServices inteface
   */
  public SecurityServices getSecurityServices();

  /**
   * Access the TrackingChanges intrface.
   * @return TrackingChanges inteface
   */
  public TrackingChanges getTrackingChanges();

  /**
   * Access the VersionManagement inteface
   * @return VersionManagement inteface
   */
  public VersionManagement getVersionManagement();

  /**
   * Access the VersionManagement inteface
   * @return VersionManagement inteface
   */
  public Reasoner getReasoner();
} // OMMClassFactory
