/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.constants;

import org.openrdf.util.Enumeration;

/**
 * A type-safe enumeration class for RDF data serialization formats.
 *
 * @author Jeen Broekstra
 * @author Arjohn Kampman
 * @version $Revision: 1.7.4.2 $
 */
public final class RDFFormat extends Enumeration {

/*------------------+
| Static stuff      |
+------------------*/

	/**
	 * Constant representing the XML-encoded RDF format.
	 **/
	public static final RDFFormat RDFXML = new RDFFormat("rdfxml");

	/**
	 * Constant representing the N-Triples format.
	 **/
	public static final RDFFormat NTRIPLES = new RDFFormat("ntriples");

	/**
	 * Constant representing the N3/Notation3 format. 
	 **/
	public static final RDFFormat N3 = new RDFFormat("n3");

	/**
	 * Constant representing the Turtle format. 
	 **/
	public static final RDFFormat TURTLE = new RDFFormat("turtle");

	/**
	 * An RDFFormat array containing all possible values.
	 **/
	private static RDFFormat[] _values = new RDFFormat[] {RDFXML, NTRIPLES, N3, TURTLE};

	/**
	 * Returns an RDFFormat constant for the specified value.
	 *
	 * @param value The String-representation of an RDFFormat constant.
	 * @return An RDFFormat object, or <tt>null</tt> if the specified value
	 * could not be resolved to an RDFFormat object.
	 **/
	public static RDFFormat forValue(String value) {
		return (RDFFormat)_forValue(_values, value);
	}

/*------------------+
| Non-static stuff  |
+------------------*/

	/**
	 * Creates a new RDFFormat object.
	 **/
	private RDFFormat(String value) {
		super(value);
	}
}
