/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.constants;

import org.openrdf.util.Enumeration;

/**
 * A type-safe enumeration class for RDF query languages.
 *
 * @author Jeen Broekstra
 * @author Arjohn Kampman
 * @version $Revision: 1.5.4.2 $
 */
public final class QueryLanguage extends Enumeration {

/*------------------+
| Static stuff      |
+------------------*/

	/**
	 * Constant representing the SeRQL query language. 
	 **/
	public static final QueryLanguage SERQL = new QueryLanguage("SeRQL");

	/**
	 * Constant representing the RQL query language. 
	 **/
	public static final QueryLanguage RQL = new QueryLanguage("RQL");

	/**
	 * Constant representing the RDQL query language. 
	 **/
	public static final QueryLanguage RDQL = new QueryLanguage("RDQL");

	/**
	 * A QueryLanguage array containing all possible values.
	 **/
	static private QueryLanguage[] _values = new QueryLanguage[] {SERQL, RQL, RDQL};

	/**
	 * Returns a QueryLanguage constant for the specified value.
	 *
	 * @param value The String-representation of a QueryLanguage constant.
	 * @return A QueryLanguage object, or <tt>null</tt> if the specified value
	 * could not be resolved to a QueryLanguage object.
	 **/
	public static QueryLanguage forValue(String value) {
		return (QueryLanguage)_forValue(_values, value);
	}

/*------------------+
| Non-static stuff  |
+------------------*/

	/**
	 * Creates a new QueryLanguage object.
	 **/
	private QueryLanguage(String value) {
		super(value);
	}
}
