/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.constants;

import org.openrdf.util.Enumeration;

/**
 * A type-safe enumeration class for response formats.
 *
 * @author Jeen Broekstra
 * @author Arjohn Kampman
 * @version $Revision: 1.6.4.2 $
 */
public final class AdminResultFormat extends Enumeration {

/*------------------+
| Static stuff      |
+------------------*/

	/**
	 * Constant representing XML format.
	 **/
	public static final AdminResultFormat XML = new AdminResultFormat("xml");

	/**
	 * Constant representing HTML format.
	 **/
	public static final AdminResultFormat HTML = new AdminResultFormat("html");

	/**
	 * A AdminResultFormat array containing all possible values.
	 **/
	static private AdminResultFormat[] _values = new AdminResultFormat[] {XML, HTML};

	/**
	 * Returns an AdminResultFormat constant for the specified value.
	 *
	 * @param value The String-representation of an AdminResultFormat constant.
	 * @return An AdminResultFormat object, or <tt>null</tt> if the specified
	 * value could not be resolved to an AdminResultFormat object.
	 **/
	public static AdminResultFormat forValue(String value) {
		return (AdminResultFormat)_forValue(_values, value);
	}

/*------------------+
| Non-static stuff  |
+------------------*/

	/**
	 * Creates a new AdminResultFormat object.
	 **/
	private AdminResultFormat(String value) {
		super(value);
	}
}
