/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.config.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

/**
 * Utility class for Configure Sesame!
 *
 * @author Peter van 't Hof
 * @version $Revision: 1.3.4.2 $
 */
public class Util {

/*--------+
| Methods |
+--------*/
	/**
	 * Creates a new 'read-only' JTextArea with the supplied text and background
	 * color. 'read-only' means that the text area cannot be edited and its
	 * carret is deinstalled.
	 *
	 * @param text Text
	 * @param background Background color
	 * @return A new 'read-only' JTextArea
	 */
	public static JTextArea createReadOnlyTextArea
		(String text, Color background) {

		JTextArea readOnlyText = new JTextArea(text);

		readOnlyText.setEditable(false);
		readOnlyText.getCaret().deinstall(readOnlyText);
		readOnlyText.setBackground(background);

		return readOnlyText;
	}

    /**
     * Creates a new 'titled' JTextArea with the supplied text and background
     * color
     *
	 * @param text Text
	 * @param background Background color
	 * @return A new 'titled' JTextArea
     */
	public static JTextArea createTitle(String text, Color background) {
		JTextArea title = createReadOnlyTextArea(text, background);

		title.setFont(new Font("Arial", Font.BOLD, 12));

		return title;
	}

	/**
	 * Creates a new borderded JLabel with the supplied image
	 *
	 * @param image Image
	 * @return A new bordered JLabel
	 */
	public static JLabel createLabel(Icon image) {
		JLabel label = new JLabel(image);

		label.setBorder(new CompoundBorder
			(new BevelBorder(BevelBorder.LOWERED), new EmptyBorder(5, 5, 5, 5)));

		return label;
	}

	/**
	 * Brings up a dialog that displays the given warning
	 *
	 * @param parent Component to display the dialog in
	 * @param warning Warning to display
	 * @param title Title for the dialog
	 */
	public static void showWarningDialog(Component parent, String warning, String title) {
		JOptionPane.showMessageDialog(parent, warning, title, JOptionPane.WARNING_MESSAGE);
	}

	/**
	 * Brings up a dialog with the options 'Yes' and 'No'
	 *
	 * @param parent Component to display the dialog in
	 * @param message Message to display
	 * @param title Title for the dialog
	 * @return Option selected by the user
	 */
	public static int showYesNoDialog(Component parent, String message, String title) {
		return JOptionPane.showConfirmDialog(parent, message, title, JOptionPane.YES_NO_OPTION);
	}

	/**
	 * @see javax.swing.SwingUtilities#windowForComponent
	 */
	public static Window getOwner(Component aComponent) {
		return SwingUtilities.windowForComponent(aComponent);
	}
}
