/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.config.ui;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.EventObject;

import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

/**
 * WRITEME
 *
 * @author Peter van 't Hof
 * @author Arjohn Kampman
 * @version $Revision: 1.4.4.2 $
 */
public class XCellEditor extends DefaultCellEditor {

/*----------+
| Variables |
+----------*/
	/** Value being edited */
	protected Object _value;

	/** XTable */
	protected XTable _table;

/*-------------+
| Constructors |
+-------------*/
	/**
	 * Creates a new XCellEditor with the supplied text and XTable
	 *
	 * @param text Text field
	 * @param table XTable
	 */
	public XCellEditor(JTextField text, XTable table) {
		super(text);

		_init(text, table);
	}

	/**
	 * Creates a new XCellEditor with the supplied combo box and XTable
	 *
	 * @param comboBox Combo box
	 * @param table XTable
	 */
	public XCellEditor(JComboBox comboBox, XTable table) {
		super(comboBox);

		_init(comboBox, table);
	}

	/**
	 * Creates a new XCellEditor with the supplied check box and XTable
	 *
	 * @param checkBox Check box
	 * @param table XTable
	 */
	public XCellEditor(JCheckBox checkBox, XTable table) {
		super(checkBox);

		_init(checkBox, table);
	}

	protected void _init(JComponent component, XTable table) {
		_table = table;
		_value = null;

		// Pressing 'Esc' triggers cancelCellEditing
		KeyStroke esc = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0);

		component.getInputMap(JComponent.WHEN_FOCUSED).put(esc, "cancelCellEditing");
		component.getActionMap().put("cancelCellEditing", new AbstractAction() {
				public void actionPerformed(ActionEvent e) {
					cancelCellEditing();
				}
			});
	}

/*--------+
| Methods |
+--------*/
	/**
	 * Validates the input
	 *
	 * @see javax.swing.DefaultCellEditor#stopCellEditing
	 */
	public boolean stopCellEditing() {
		if (isValid()) {
			if (super.stopCellEditing()) {

				// Reset value
				_value = null;

				return true;
			}
		}

		return false;
	}

	/**
	 * If editing is canceled, removes the new row
	 *
	 * @see javax.swing.DefaultCellEditor#cancelCellEditing
	 */
	public void cancelCellEditing() {
		if (_value == null) {

			// Editing a new row
			_table.getXTableModel().removeNewRow();
		}

		super.cancelCellEditing();
	}

	/**
	 * Focusses on the editor
	 *
	 * @see javax.swing.DefaultCellEditor#shouldSelectCell
	 */
	public boolean shouldSelectCell(EventObject o) {
		boolean shouldSelectCell = super.shouldSelectCell(o);

		getComponent().requestFocus();

		return shouldSelectCell;
	}

	/**
	 * Sets this value to the supplied value
	 *
	 * @param value Value
	 */
	public void setValue(Object value) {
		_value = value;
	}

	/**
	 * Checks if the input is validate
	 *
	 * @return Boolean indicating if the input is validate
	 */
	public boolean isValid() {
		return true;
	}
}
