/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.config.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.util.GridBagUtil;
import org.openrdf.sesame.config.ui.util.Util;

/**
 * User JPanel of ConfigureSesameFrame
 *
 * @author Peter van 't Hof
 * @author Arjohn Kampman
 * @version $Revision: 1.4.4.2 $
 */
public class UserTab extends JPanel
	implements ActionListener, ListSelectionListener {

/*----------+
| Variables |
+----------*/

	/** SystemConfig */
	protected SystemConfig _config;

	/** UserTable */
	protected UserTable _table;

	/** Add button */
	protected JButton _addButton;

	/** Remove button */
	protected JButton _removeButton;

/*-------------+
| Constructors |
+-------------*/
	/**
	 * Creates a new UserTab with the supplied SystemConfig
	 *
	 * @param config SystemConfig
	 */
	public UserTab(SystemConfig config) {
		_config = config;

		setLayout(new GridBagLayout());

		// Add an empty border of 8 pixels
		setBorder(new EmptyBorder(8, 8, 8, 8));

		// Icon
		URL url = getClass().getResource("icons/user.png");
		JLabel icon = new JLabel(new ImageIcon(url));

		GridBagUtil.constrain(this, icon,
			 0, 0, 1, 1,
			 GridBagConstraints.NONE, GridBagConstraints.CENTER, 0, 0,
			 0, 0, 4, 4);

		// Explanation
		JTextArea explanation = Util.createReadOnlyTextArea(
			"Use the list below to add users to, or remove users from Sesame,\n" +
			"and to change their passwords and other settings.",
			getBackground());

		GridBagUtil.constrain(this, explanation,
			 1, 0, 1, 1,
			 GridBagConstraints.NONE, GridBagConstraints.WEST, 0, 0,
			 0, 4, 4, 0);

		// Table title
		JTextArea title = Util.createTitle("Users for Sesame:", getBackground());

		GridBagUtil.constrain(this, title,
			 0, 1, 2, 1,
			 GridBagConstraints.NONE, GridBagConstraints.WEST, 0, 0,
			 4, 0, 4, 0);

		// User table
		GridBagUtil.constrain(this, _createList(),
			 0, 2, 2, 1,
			 GridBagConstraints.BOTH, GridBagConstraints.CENTER, 1, 1,
			 4, 0, 4, 0);

		// Buttons
		GridBagUtil.constrain(this, _createButtons(),
			 0, 3, 2, 1,
			 GridBagConstraints.NONE, GridBagConstraints.EAST, 1, 0,
			 4, 0, 0, 0);

		_table.getSelectionModel().addListSelectionListener(this);

		_enableDisableComponents();
	}

	protected JScrollPane _createList() {
		JScrollPane list = new JScrollPane();

		_table = new UserTable(_config);

		JViewport viewport = list.getViewport();

		viewport.add(_table);
		viewport.setBackground(Color.white);
		viewport.setPreferredSize(new Dimension(450, 200));

		list.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);

		return list;
	}

	protected JPanel _createButtons() {
		// Use a GridLayout to ensure the buttons get equal sizes:
		JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 4, 0));

		// Add button
		URL url = getClass().getResource("icons/add-user.png");
		_addButton = new JButton(new ImageIcon(url));
		_addButton.setToolTipText("Add new user to list");
		buttonPanel.add(_addButton);
		_addButton.addActionListener(this);

		// Remove button
		url = getClass().getResource("icons/remove-user.png");
		_removeButton = new JButton(new ImageIcon(url));
		_removeButton.setToolTipText("Remove user from list");
		buttonPanel.add(_removeButton);
		_removeButton.addActionListener(this);

		return buttonPanel;
	}

/*--------+
| Methods |
+--------*/

	public void actionPerformed(ActionEvent event) {
		if (_table.stopCellEditing()) {
			Object source = event.getSource();

			if (source == _addButton) {
				_table.addNewRow();
			}
			else if (source == _removeButton) {
				_table.removeRow();
			}
		}
		else {
			_table.requestFocus();
		}
	}

	public void valueChanged(ListSelectionEvent e) {
		_enableDisableComponents();
	}

	/**
	 * Enables/disables components according to the
	 * selections in the user table.
	 **/
	protected void _enableDisableComponents() {
		int selectedUserIdx = _table.getSelectedRow();
		_removeButton.setEnabled(selectedUserIdx != -1);
	}

	public void requestFocus() {
		super.requestFocus();

		if (_table.isEditing()) {
			_table.requestFocus();
		}
	}
}
