/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.config.ui;

import java.awt.Toolkit;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

/**
 * Integer JTextField
 *
 * @author Peter van 't Hof
 * @author Arjohn Kampman
 * @version $Revision: 1.4.4.2 $
 */
class IntTextField extends JTextField {

/*-------------+
| Constructors |
+-------------*/
	/** Creates a new IntTextField */
	public IntTextField() {
		super();
	}

/*--------+
| Methods |
+--------*/
	protected Document createDefaultModel() {
		return new IntTextDocument();
	}

	/**
	 * Gets integer
	 *
	 * @return Integer
	 */
	public int getInt() {
		return getInt(getText());
	}

	public void setInt(int value) {
		setText(String.valueOf(value));
	}

	/**
	 * Parses the given text to an integer
	 *
	 * @param Text
	 * @return Integer
	 */
	public static int getInt(String text) {
		int integer = 0;

		try {
			integer = Integer.parseInt(text);
		}
		catch (NumberFormatException nfe) {

			// Input validation is done by IntTextDocument
		}

		return integer;
	}
}

/**
 * Default model of IntTextField
 *
 * @author Peter van 't Hof
 * @version %I%, %G%
 */
class IntTextDocument extends PlainDocument {

/*--------+
| Methods |
+--------*/
	/**
	 * Validates input. Doesn 't accept anything, except for integers.
	 *
	 * @see PlainDocument.insertString
	 */
	public void insertString(int offset, String string, AttributeSet set)
		throws BadLocationException {
		if (string == null) {
			return;
		}

		try {
			Integer.parseInt(string);

			super.insertString(offset, string, set);
		}
		catch (NumberFormatException e) {
			Toolkit.getDefaultToolkit().beep();
		}
	}
}
