/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.config.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

import javax.swing.JLabel;

/**
 * A horizontal separator between vertically-spaced components
 *
 * @author Peter van 't Hof
 * @author Arjohn Kampman
 * @version $Revision: 1.4.4.2 $
 */
public class DialogSeparator extends JLabel {

/*----------+
| Variables |
+----------*/
	/** Offset */
	public static final int OFFSET = 15;

/*-------------+
| Constructors |
+-------------*/
	/** Creates a new DialogSeparator */
	public DialogSeparator() {}

	/** Creates a new DialogSeparator with the supplied text */
	public DialogSeparator(String text) {
		super(text);
	}

/*--------+
| Methods |
+--------*/
	/**
	 * Returns a shallow area with a small fixed height and variable width
	 *
	 * @see javax.swing.JLabel#getPreferredSize
	 */
	public Dimension getPreferredSize() {
		return new Dimension(getParent().getWidth(), 20);
	}

	public Dimension getMinimumSize() {
		return getPreferredSize();
	}

	public Dimension getMaximumSize() {
		return getPreferredSize();
	}

	/**
	 * Draws a separating bar with a raised appearance
	 */
	public void paintComponent(Graphics graphics) {
		super.paintComponent(graphics);

		graphics.setColor(getBackground());
		graphics.fillRect(0, 0, getWidth(), getHeight());

		Dimension dimension = getSize();

		int y = (dimension.height -3)/2;

		graphics.setColor(Color.white);
		graphics.drawLine(0, y, dimension.width -1, y);

		y++;

		graphics.drawLine(0, y, 1, y);
		graphics.setColor(Color.gray);
		graphics.drawLine(dimension.width -1, y, dimension.width, y);

		y++;

		graphics.drawLine(1, y, dimension.width -1, y);

		String text = getText();

		if (text.length() == 0) {
			return;
		}

		graphics.setFont(getFont());

		FontMetrics metrics = graphics.getFontMetrics();

		y = (dimension.height + metrics.getAscent())/2;

		graphics.setColor(getBackground());
		graphics.fillRect(OFFSET -5, 0, OFFSET +metrics.stringWidth(text), dimension.height);
		graphics.setColor(getForeground());
		graphics.drawString(text, OFFSET, y);
	}
}
