/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.config.ui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;

/**
 * Main class of Configure Sesame!
 *
 * @author Peter van 't Hof
 * @author Arjohn Kampman
 * @version $Revision: 1.5.4.2 $
 */
public class ConfigureSesame {

	/**
	 * Starts Configure Sesame! with the supplied arguments
	 *
	 * @param args Arguments. For now, should be empty
	 */
	public static void main(String[] args) {
		ConfigureSesameFrame frame = new ConfigureSesameFrame();

		frame.pack();

		// Center the ConfigureSesameFrame
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension frameSize = frame.getSize();
		int x = (screenSize.width - frameSize.width) / 2;
		int y = (screenSize.height - frameSize.height) / 2;
		
		// Frame could be larger than the screen, resulting in negative
		// x or y coordinates
		x = (x >= 0) ? x : 0;
		y = (y >= 0) ? y : 0;

		frame.setLocation(x, y);

		// Load any system.conf file that has been specified on the command line
		if (args.length >= 1) {
			File file = new File(args[0]);
			frame.load(file);
		}

		// Show the frame
		frame.setVisible(true);
	}
}
