/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.config.ui;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

/**
 * Cell renderer to display a check box
 *
 * @author Peter van 't Hof
 * @author Arjohn Kampman
 * @version $Revision: 1.4.4.2 $
 */
public class CheckCellRenderer extends JCheckBox implements TableCellRenderer {

/*----------+
| Variables |
+----------*/
	/** Border */
	protected Border _noFocusBorder;

/*-------------+
| Constructors |
+-------------*/
	/** Creates a new CheckCellRenderer */
	public CheckCellRenderer() {
		super();

		_noFocusBorder = new EmptyBorder(1, 2, 1, 2);

		setBorder(_noFocusBorder);
		setOpaque(true);
	}

/*--------+
| Methods |
+--------*/
	/**
	 * Sets state, font and colors of this CheckCellRenderer before returning it
	 *
	 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent
	 */
	public Component getTableCellRendererComponent
		(JTable table, Object value, boolean isSelected,
		 boolean hasFocus, int row, int column) {

		if (value instanceof Boolean) {
			Boolean bool = (Boolean)value;

			setSelected(bool.booleanValue());
		}

		Color background, foreground = null;

		if (isSelected && !hasFocus) {
			background = table.getSelectionBackground();
			foreground = table.getSelectionForeground();
		}
		else {
			background = table.getBackground();
			foreground = table.getForeground();
		}

		setBackground(background);
		setForeground(foreground);
		setFont(table.getFont());

		Border border = null;

		if (hasFocus) {
			border = UIManager.getBorder("Table.focusCellHighlightBorder");
		}
		else {
			border = _noFocusBorder;
		}

		setBorder(border);

		return this;
	}
}
