/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.config.ui;

import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

import org.openrdf.sesame.config.ui.util.GridBagUtil;
import org.openrdf.sesame.config.ui.util.Util;

/**
 * About JDialog of SystemConfigFrame
 *
 * @author Peter van 't Hof
 * @author Arjohn Kampman
 * @version $Revision: 1.5.4.2 $
 */
public class AboutDialog extends JDialog implements ActionListener {

/*-------------+
| Constructors |
+-------------*/

	/**
	 * Creates a new AboutDialog with the supplied owner
	 *
	 * @param owner Frame to display this AboutDialog in
	 */
	public AboutDialog(Frame owner) {
		// Set title
		super(owner, "About Configure Sesame!", true);

		Container contentPane = getContentPane();
		contentPane.setLayout(new GridBagLayout());

		// Icon
		URL url = getClass().getResource("icons/questionmark.png");
		JLabel icon = new JLabel(new ImageIcon(url));
		GridBagUtil.constrain(contentPane, icon,
				0, 0, 1, 3,
				GridBagConstraints.NONE, GridBagConstraints.CENTER, 0, 0,
				8, 8, 4, 4);

		// Copyright notice
		/* FIXME If no whitespace is appended to the copyright notice, the last
		 * '3' of '2003' will not be displayed.
		 */
		JTextArea copyright = _createReadOnlyTextArea(
				"Configure Sesame! v 1.1\n" +
				"Copyright (c) 2003 Aduna ",
				"Helvetica", Font.BOLD);
		GridBagUtil.constrain(contentPane, copyright,
				1, 0, 1, 1,
				GridBagConstraints.NONE, GridBagConstraints.WEST, 0, 0,
				8, 4, 4, 8);

		// Descriptive text
		JTextArea text = _createReadOnlyTextArea(
				"This program configures Sesame",
				"Arial", Font.PLAIN);
		GridBagUtil.constrain(contentPane, text,
				1, 1, 1, 1,
				GridBagConstraints.NONE, GridBagConstraints.WEST, 0, 0,
				4, 4, 4, 8);

		// Feedback address
		JTextArea mailTo = _createReadOnlyTextArea(
				"Please post any comments on the forum at\nwww.openrdf.org",
				"Arial", Font.PLAIN);
		GridBagUtil.constrain(contentPane, mailTo,
				1, 2, 1, 1,
				GridBagConstraints.NONE, GridBagConstraints.WEST, 0, 0,
				4, 4, 4, 8);

		// Separator
		GridBagUtil.constrain(contentPane, new JSeparator(),
				0, 3, 2, 1,
				GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, 1, 0,
				4, 8, 4, 8);

		// Close button
		JButton okButton = new JButton("Close");
		GridBagUtil.constrain(contentPane, okButton,
				0, 4, 2, 1,
				GridBagConstraints.NONE, GridBagConstraints.CENTER, 0, 0,
				4, 4, 8, 4);
		okButton.addActionListener(this);

		pack();
		setLocationRelativeTo(owner);
		setResizable(false);
	}

/*--------+
| Methods |
+--------*/

	public void actionPerformed(ActionEvent e) {
		// Close button clicked
		setVisible(false);
		dispose();
	}

	protected JTextArea _createReadOnlyTextArea(String text, String name, int style) {
		JTextArea textArea = Util.createReadOnlyTextArea(text, getBackground());
		textArea.setFont(new Font(name, style, 12));
		return textArea;
	}
}
