/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.config;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.openrdf.util.xml.XmlWriter;

import org.openrdf.sesame.repository.RepositoryList;

public class RepositoryListWriter {

/*---------------+
| Methods        |
+---------------*/

	public void write(RepositoryList repList, OutputStream outputStream)
		throws IOException
	{
		List readableReps = repList.getReadableRepositories();
		List writeableReps = repList.getWritableRepositories();
		Set allRepositories = new HashSet(readableReps);
		allRepositories.addAll(writeableReps);

		XmlWriter xmlWriter = new XmlWriter(outputStream);
		xmlWriter.setPrettyPrint(true);

		xmlWriter.startDocument();
		xmlWriter.startTag("repositorylist");

		Iterator iter = allRepositories.iterator();
		while (iter.hasNext()) {
			RepositoryInfo repInfo = (RepositoryInfo)iter.next();

			xmlWriter.setAttribute("id", repInfo.getRepositoryId());
			xmlWriter.setAttribute("readable", readableReps.contains(repInfo));
			xmlWriter.setAttribute("writeable", writeableReps.contains(repInfo));
			xmlWriter.startTag("repository");

			if (repInfo.getTitle() != null) {
				xmlWriter.textElement("title", repInfo.getTitle());
			}

			xmlWriter.endTag("repository");
		}

		xmlWriter.endTag("repositorylist");
		xmlWriter.endDocument();
	}
}
