/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.config;

import org.openrdf.sesame.repository.RepositoryList;

/**
 * A RepositoryListListener that can be used to build a RepositoryListImpl.
 *
 * @see RepositoryListImpl
 **/
public class RepositoryListBuilder implements RepositoryListListener {

/*-----------------------------------------------------+
| Variables                                            |
+-----------------------------------------------------*/

	/**
	 * The RepositoryListImpl.
	 **/
	private RepositoryList _repositoryList;

/*-----------------------------------------------------+
| Constructors                                         |
+-----------------------------------------------------*/

	/**
	 * Creates a new RepositoryListBuilder.
	 **/
	public RepositoryListBuilder() {
	}

/*-----------------------------------------------------+
| Methods                                              |
+-----------------------------------------------------*/

	/**
	 * Gets the RepositoryListImpl that has been built. This method only returns
	 * a list when the results have (partially) been parsed, and when the
	 * builder hasn't been cleared in the meantime.
	 *
	 * @return A RepositoryListImpl, or null if not available.
	 **/
	public RepositoryList getRepositoryList() {
		return _repositoryList;
	}

	/**
	 * Clear the builder. Any RepositoryListImpl that has been built so far will
	 * be removed.
	 **/
	public void clear() {
		// remove any results
		_repositoryList = null;
	}

/*-----------------------------------------------------+
| Methods from the RepositoryListListener interface    |
+-----------------------------------------------------*/

	/** Indicates the start of a repository list. **/
	public void startRepositoryList() {
		_repositoryList = new RepositoryListImpl();
	}

	/** Indicates the end of a repository list. **/
	public void endRepositoryList() {
		// We're done, thanks for telling me ;-)
	}

	/** Delivers information about an available repository. **/
	public void repository(
		String id, String title, boolean readable, boolean writable)
	{
		_repositoryList.addRepository(id, title, readable, writable);
	}
}
