/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact:
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.config;

import java.io.Serializable;


public class DefaultRepositoryInfo implements RepositoryInfo, Serializable {

/*-----------------------------+
| Variables                    |
+-----------------------------*/

	private String _id;
	private String _title;
	private String _sailType = null;
	private boolean _readable;
	private boolean _writeable;

/*-----------------------------+
| Constructors                 |
+-----------------------------*/

	public DefaultRepositoryInfo(String id) {
		this(id, null, true, true);
	}

	/**
	 * Creates a new RepositoryConfig with the supplied repository id and title
	 *
	 * @param id Repository id
	 * @param title Repository title
	 */
	public DefaultRepositoryInfo(String id, String title) {
		this(id, title, true, true);
	}

	public DefaultRepositoryInfo(
		String id, String title, boolean readable, boolean writeable)
	{
		_id = id;
		_title = title;
		_readable = readable;
		_writeable = writeable;
	}

/*-----------------------------+
| Methods                      |
+-----------------------------*/

	public String getRepositoryId() {
		return _id;
	}

	public String getTitle() {
		return _title;
	}

	public boolean isReadable() {
		// FIXME
		return _readable;
	}

	public boolean isWriteable() {
		// FIXME
		return _writeable;
	}

	public String getSailType() {
		// FIXME how to determine this remotely?
		return _sailType;
	}
}
