/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.admin;

import org.openrdf.model.Statement;

/**
 * A simple AdminListener implementation that reports all messages to
 * System.out. Useful for debugging purposes.
 *
 * @author Jeen Broekstra
 *
 * @version $Revision: 1.4.4.2 $
 */
public class StdOutAdminListener implements AdminListener {

	// Start/end transaction
	public void transactionStart() {
		System.out.println("Transaction started.");
	}

	public void transactionEnd() {
		System.out.println("Transaction finished.");
	}

	// Status. msg may be null.
	public void status(
			String msg, int lineNo, int colNo)
	{
		System.out.println("[status ] " + _createMessage(msg, lineNo, colNo, null));
	}

	// Notification. msg may be null.
	public void notification(
			String msg, int lineNo, int colNo, Statement statement)
	{
		System.out.println("[notify ] " + _createMessage(msg, lineNo, colNo, statement));
	}

	// Warning. msg may be null.
	public void warning(
			String msg, int lineNo, int colNo, Statement statement)
	{
		System.out.println("[WARNING] " + _createMessage(msg, lineNo, colNo, statement));
	}

	// Error. msg may be null.
	public void error(
			String msg, int lineNo, int colNo, Statement statement)
	{
		System.out.println("[ERROR  ] " + _createMessage(msg, lineNo, colNo, statement));
	}

	private String _createMessage(
			String msg, int lineNo, int colNo, Statement statement)
	{
		StringBuffer result = new StringBuffer();

		if (lineNo != -1) {
			result.append("(");
			result.append(lineNo);
			result.append(", ");
			result.append(colNo);
			result.append(")");
		}

		result.append(": ");
		result.append(msg);

		if (statement != null) {
			result.append("\n  -> subject  : " + statement.getSubject());
			result.append("\n  -> predicate: " + statement.getPredicate());
			result.append("\n  -> object   : " + statement.getObject());
		}

		return result.toString();
	}
}
