/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.admin;

import java.text.NumberFormat;


public class StatusReporter extends Thread {

	protected long _interval;
	protected long _startTime;
	protected long _endTime;
	protected long _wakeUpTime;

	protected boolean _continueRunning;

	protected int _statementCount;

	protected AdminListener _report;

	protected NumberFormat _nf;

	public StatusReporter(long interval, AdminListener report) {
		setDaemon(true);

		_interval = interval;
		_report = report;

		setDaemon(true);
		_nf = NumberFormat.getInstance();

		_startTime = _endTime = -1;
		_continueRunning = true;
	}

	public void run() {
		_statementCount = 0;

		_startTime = System.currentTimeMillis();
		_endTime = -1;
		_wakeUpTime = _startTime + _interval;

		while (_continueRunning) {
			long delay = _wakeUpTime - System.currentTimeMillis();

			if (delay <= 0.0) {
				_writeStatus();
				_wakeUpTime += _interval;
				continue;
			}

			try {
				Thread.sleep(delay);
			}
			catch (InterruptedException ignore) {
				// no-op
			}
		}
	}

	public synchronized void stopRunning() {
		_continueRunning = false;
		_endTime = System.currentTimeMillis();
		_writeStatus();
		this.interrupt();
	}

	public void statementAdded() {
		_statementCount++;
	}

	public int getStatementCount() {
		return _statementCount;
	}

	public long getRunningTime() {
		if (_startTime == -1) {
			// Thread hasn't even started yet!
			return 0;
		}
		else if (_endTime > 0) {
			// Thread was stopped.
			return _endTime - _startTime;
		}
		else {
			// Thread still running.
			return System.currentTimeMillis() - _startTime;
		}
	}

	protected void _writeStatus() {
		StringBuffer msg = new StringBuffer(64);
		
		msg.append("Processed ");
		msg.append( _nf.format(_statementCount) );
		msg.append(" statements in ");
		msg.append( (getRunningTime() / 1000) );
		msg.append(" seconds");
		if (_endTime < 0) {
			msg.append("; processing continues");
		}

		_report.status(msg.toString(), -1, -1);
	}
}
