/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.admin;

import org.openrdf.model.Statement;

/**
 * A dummy AdminListener that does absolutely nothing at all. This class is
 * mainly meant for testing purposes where admin messages can be safely
 * ignored.
 **/
public class DummyAdminListener implements AdminListener {

/*--------------------------------------------+
| Constructors                                |
+--------------------------------------------*/

	/**
	 * Creates a new DummyAdminListener object.
	 **/
	public DummyAdminListener() {
	}

/*--------------------------------------------+
| Methods                                     |
+--------------------------------------------*/

	public void transactionStart() {
	}

	public void transactionEnd() {
	}

	public void status(String msg, int lineNo, int columnNo) {
	}

	public void notification(String msg, int lineNo, int columnNo, Statement stat) {
	}

	public void warning(String msg, int lineNo, int columnNo, Statement stat) {
	}

	public void error(String msg, int lineNo, int columnNo, Statement stat) {
	}
}
