/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.sesame.admin;

import org.openrdf.model.Statement;

/**
 * A listener for messages that are reported during administrative
 * operations.
 **/
public interface AdminListener {

	/**
	 * Indicates the start of a transaction.
	 **/
	public void transactionStart();

	/**
	 * Indicates the end of a transaction.
	 **/
	public void transactionEnd();

	/**
	 * A status message with optional line and column number to
	 * indicate progress.
	 *
	 * @param msg The status message.
	 * @param lineNo A line number, or -1 if unavailable or irrelevant.
	 * @param columnNo A column number, or -1 if unavailable or irrelevant.
	 **/
	public void status(String msg, int lineNo, int columnNo);

	/**
	 * A notification message (not an error) with optionally line and column
	 * number and the statement to indicate the source of the notification.
	 *
	 * @param msg The notification message.
	 * @param lineNo A line number, or -1 if unavailable or irrelevant.
	 * @param columnNo A column number, or -1 if unavailable or irrelevant.
	 * @param statement The statement, or <tt>null</tt> if unavailable or
	 * irrelevant.
	 **/
	public void notification(
		String msg, int lineNo, int columnNo, Statement statement);

	/**
	 * A warning message with optionally line and column number and the
	 * statement to indicate the source of the warning.
	 *
	 * @param msg The warning message.
	 * @param lineNo A line number, or -1 if unavailable or irrelevant.
	 * @param columnNo A column number, or -1 if unavailable or irrelevant.
	 * @param statement The statement, or <tt>null</tt> if unavailable or
	 * irrelevant.
	 **/
	public void warning(
		String msg, int lineNo, int columnNo, Statement statement);

	/**
	 * An error message with optionally line and column number and
	 * the statement to indicate the source of the error.
	 *
	 * @param msg The error message.
	 * @param lineNo A line number, or -1 if unavailable or irrelevant.
	 * @param columnNo A column number, or -1 if unavailable or irrelevant.
	 * @param statement The statement, or <tt>null</tt> if unavailable or
	 * irrelevant.
	 **/
	public void error(
		String msg, int lineNo, int columnNo, Statement statement);
}
