/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.nativerdf.datastore;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.openrdf.sesame.sailimpl.nativerdf.datastore.TransferUtil;

public class IDFile {
    private static final long HEADER_LENGTH = 8L;
    private static final long ITEM_SIZE = 8L;
    private File _file;
    private RandomAccessFile _raf;
    private FileChannel _fileChannel;
    private File _txnFile;
    private RandomAccessFile _txnRaf;
    private FileChannel _txnChannel;
    private ByteBuffer _txnBuffer = ByteBuffer.allocate(8);
    private boolean _isolatedTransaction;
    private boolean _dataCleared;

    public IDFile(File file) throws IOException {
        this._file = file;
        this._file.createNewFile();
        this._raf = new RandomAccessFile(this._file, "rw");
        this._fileChannel = this._raf.getChannel();
        if (this._fileChannel.size() == 0L) {
            this._fileChannel.write(ByteBuffer.wrap(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}));
        }
    }

    public void startTransaction(boolean isolateTransaction) throws IOException {
        this._isolatedTransaction = isolateTransaction;
        if (isolateTransaction) {
            this._txnFile = new File(this._file.getParentFile(), "txn_" + this._file.getName());
            if (!this._txnFile.exists()) {
                this._txnFile.createNewFile();
            }
            this._txnRaf = new RandomAccessFile(this._txnFile, "rw");
            this._txnChannel = this._txnRaf.getChannel();
            if (this._txnChannel.size() > 0L) {
                this._txnChannel.truncate(0L);
            }
            this._dataCleared = false;
        }
    }

    public void commitTransaction() throws IOException {
        if (this._isolatedTransaction) {
            if (this._dataCleared) {
                this._fileChannel.truncate(8L);
            }
            this._txnChannel.position(0L);
            TransferUtil.transferFrom(this._txnChannel, this._fileChannel.size(), this._txnChannel.size(), this._fileChannel);
            this._txnRaf.close();
            this._txnRaf = null;
            this._txnChannel = null;
            this._txnFile.delete();
            this._txnFile = null;
        }
    }

    public void rollbackTransaction() throws IOException {
        if (!this._isolatedTransaction) {
            throw new IOException("Unisolated transactions cannot be rolled back");
        }
        this._txnRaf.close();
        this._txnRaf = null;
        this._txnChannel = null;
        this._txnFile.delete();
        this._txnFile = null;
    }

    public int getNewID() throws IOException {
        if (this._isolatedTransaction) {
            if (this._dataCleared) {
                return (int)((this._txnChannel.size() + 8L) / 8L);
            }
            return (int)((this._txnChannel.size() + this._fileChannel.size()) / 8L);
        }
        return (int)(this._fileChannel.size() / 8L);
    }

    public int getMaxID() throws IOException {
        return (int)(this._fileChannel.size() / 8L) - 1;
    }

    public void storeOffset(int id, long offset) throws IOException {
        this._txnBuffer.clear();
        this._txnBuffer.putLong(0, offset);
        long txnOffset = 8L * (long)id;
        FileChannel channel = this._fileChannel;
        if (this._isolatedTransaction) {
            channel = this._txnChannel;
            txnOffset -= this._dataCleared ? 8L : this._fileChannel.size();
        }
        channel.write(this._txnBuffer, txnOffset);
    }

    public long getOffset(int id, boolean dirtyReads) throws IOException {
        long offset = 8L * (long)id;
        FileChannel channel = null;
        if (dirtyReads && this._isolatedTransaction && (this._dataCleared || offset >= this._fileChannel.size())) {
            channel = this._txnChannel;
            offset -= this._dataCleared ? 8L : this._fileChannel.size();
        } else {
            channel = this._fileChannel;
        }
        ByteBuffer buf = ByteBuffer.allocate(8);
        channel.read(buf, offset);
        return buf.getLong(0);
    }

    public void clear() throws IOException {
        if (this._isolatedTransaction) {
            this._txnChannel.truncate(0L);
            this._dataCleared = true;
        } else {
            this._fileChannel.truncate(8L);
        }
    }

    public void close() throws IOException {
        if (this._txnChannel != null) {
            this.rollbackTransaction();
        }
        this._raf.close();
    }
}

