/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.rdfxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.openrdf.rio.NamespaceListener;
import org.openrdf.rio.ParseLocationListener;
import org.openrdf.rio.rdfxml.Att;
import org.openrdf.rio.rdfxml.Atts;
import org.openrdf.rio.rdfxml.RdfXmlParser;
import org.openrdf.util.uri.URI;
import org.openrdf.util.xml.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class SAXFilter
implements ContentHandler {
    private RdfXmlParser _rdfParser;
    private Locator _locator;
    private ParseLocationListener _locListener;
    private NamespaceListener _nsListener;
    private Stack _elInfoStack = new Stack();
    private StringBuffer _charBuf = new StringBuffer(512);
    private URI _documentURI;
    private boolean _parseStandAloneDocuments = false;
    private ElementInfo _deferredElement = null;
    private Map _newNamespaceMappings = new HashMap();
    private boolean _inRdfContext;
    private int _rdfContextStackHeight;
    private boolean _parseLiteralMode = false;
    private int _xmlLiteralStackHeight;
    private List _xmlLiteralPrefixes = new ArrayList();
    private List _unknownPrefixesInXmlLiteral = new ArrayList();

    public SAXFilter(RdfXmlParser rdfParser) {
        this._rdfParser = rdfParser;
    }

    public Locator getLocator() {
        return this._locator;
    }

    public void setParseLocationListener(ParseLocationListener el) {
        this._locListener = el;
        if (this._locator != null) {
            this._locListener.parseLocationUpdate(this._locator.getLineNumber(), this._locator.getColumnNumber());
        }
    }

    public ParseLocationListener getParseLocationListener() {
        return this._locListener;
    }

    public void setNamespaceListener(NamespaceListener nl) {
        this._nsListener = nl;
    }

    public NamespaceListener getNamespaceListener() {
        return this._nsListener;
    }

    public void clear() {
        this._locator = null;
        this._elInfoStack.clear();
        this._charBuf.setLength(0);
        this._documentURI = null;
        this._deferredElement = null;
        this._newNamespaceMappings.clear();
        this._inRdfContext = false;
        this._rdfContextStackHeight = 0;
        this._parseLiteralMode = false;
        this._xmlLiteralStackHeight = 0;
        this._xmlLiteralPrefixes.clear();
        this._unknownPrefixesInXmlLiteral.clear();
    }

    public void setDocumentURI(String documentURI) {
        this._documentURI = this._createBaseURI(documentURI);
    }

    public void setParseStandAloneDocuments(boolean standAloneDocs) {
        this._parseStandAloneDocuments = standAloneDocs;
    }

    public boolean getParseStandAloneDocuments() {
        return this._parseStandAloneDocuments;
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
        if (this._locListener != null) {
            this._locListener.parseLocationUpdate(locator.getLineNumber(), locator.getColumnNumber());
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this._deferredElement != null) {
            this._reportDeferredStartElement();
        }
        this._newNamespaceMappings.put(prefix, uri);
        if (this._parseLiteralMode) {
            this._xmlLiteralPrefixes.add(prefix);
        }
        if (this._nsListener != null) {
            this._nsListener.handleNamespace(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) {
        if (this._parseLiteralMode) {
            this._xmlLiteralPrefixes.remove(prefix);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        if (this._deferredElement != null) {
            this._reportDeferredStartElement();
        }
        if (this._parseLiteralMode) {
            this._appendStartTag(qName, attributes);
            ++this._xmlLiteralStackHeight;
        } else {
            ElementInfo parent = this._peekStack();
            ElementInfo elInfo = new ElementInfo(parent, qName, namespaceURI, localName);
            elInfo.setNamespaceMappings(this._newNamespaceMappings);
            this._newNamespaceMappings.clear();
            if (!(this._inRdfContext || !this._parseStandAloneDocuments || localName.equals("RDF") && namespaceURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#"))) {
                this._inRdfContext = true;
            }
            if (!this._inRdfContext) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attQName = attributes.getQName(i);
                    if ("xml:base".equals(attQName)) {
                        elInfo.setBaseURI(attributes.getValue(i));
                        continue;
                    }
                    if (!"xml:lang".equals(attQName)) continue;
                    elInfo.xmlLang = attributes.getValue(i);
                }
                this._elInfoStack.push(elInfo);
                if (localName.equals("RDF") && namespaceURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                    this._inRdfContext = true;
                    this._rdfContextStackHeight = 0;
                }
            } else {
                this._checkAndCopyAttributes(attributes, elInfo);
                this._deferredElement = elInfo;
            }
        }
    }

    private void _reportDeferredStartElement() throws SAXException {
        this._elInfoStack.push(this._deferredElement);
        ++this._rdfContextStackHeight;
        this._rdfParser.setBaseURI(this._deferredElement.baseURI);
        this._rdfParser.setXmlLang(this._deferredElement.xmlLang);
        this._rdfParser.startElement(this._deferredElement.namespaceURI, this._deferredElement.localName, this._deferredElement.qName, this._deferredElement.atts);
        this._deferredElement = null;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this._rdfParser._verifyData && !this._parseLiteralMode) {
            ElementInfo elInfo = this._deferredElement != null ? this._deferredElement : this._peekStack();
            if (!qName.equals(elInfo.qName)) {
                this._rdfParser.sendFatalError("expected end tag </'" + elInfo.qName + ">, " + "found </" + qName + ">");
            }
        }
        if (!this._inRdfContext) {
            this._elInfoStack.pop();
            this._charBuf.setLength(0);
            return;
        }
        if (this._deferredElement == null && this._rdfContextStackHeight == 0) {
            this._inRdfContext = false;
            this._elInfoStack.pop();
            this._charBuf.setLength(0);
            return;
        }
        if (this._parseLiteralMode && this._xmlLiteralStackHeight > 0) {
            this._appendEndTag(qName);
            --this._xmlLiteralStackHeight;
            return;
        }
        if (this._deferredElement != null) {
            this._rdfParser.setBaseURI(this._deferredElement.baseURI);
            this._rdfParser.setXmlLang(this._deferredElement.xmlLang);
            this._rdfParser.emptyElement(this._deferredElement.namespaceURI, this._deferredElement.localName, this._deferredElement.qName, this._deferredElement.atts);
            this._deferredElement = null;
        } else {
            if (this._parseLiteralMode) {
                this._insertUsedContextPrefixes();
            }
            String s = this._charBuf.toString().trim();
            this._charBuf.setLength(0);
            if (s.length() > 0 || this._parseLiteralMode) {
                this._rdfParser.text(s);
                this._parseLiteralMode = false;
            }
            this._elInfoStack.pop();
            --this._rdfContextStackHeight;
            this._rdfParser.endElement(namespaceURI, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._inRdfContext) {
            if (this._deferredElement != null) {
                this._reportDeferredStartElement();
            }
            if (this._parseLiteralMode) {
                String s = new String(ch, start, length);
                s = XmlUtil.escapeChars((String)s);
                this._charBuf.append(s);
            } else {
                this._charBuf.append(ch, start, length);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this._parseLiteralMode) {
            this._charBuf.append(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) {
    }

    public void skippedEntity(String name) {
    }

    private void _checkAndCopyAttributes(Attributes attributes, ElementInfo elInfo) throws SAXException {
        Atts atts = new Atts(attributes.getLength());
        int attCount = attributes.getLength();
        for (int i = 0; i < attCount; ++i) {
            String qName = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (qName.startsWith("xml")) {
                if (qName.equals("xml:lang")) {
                    elInfo.xmlLang = value;
                    continue;
                }
                if (!qName.equals("xml:base")) continue;
                elInfo.setBaseURI(value);
                continue;
            }
            String namespace = attributes.getURI(i);
            String localName = attributes.getLocalName(i);
            if ("".equals(namespace) && (localName.equals("ID") || localName.equals("about") || localName.equals("resource") || localName.equals("parseType") || localName.equals("type"))) {
                this._rdfParser.sendWarning("use of unqualified attribute " + localName + " has been deprecated");
                namespace = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
            }
            if (this._rdfParser._verifyData && "".equals(namespace)) {
                this._rdfParser.sendError("unqualified attribute '" + qName + "' not allowed");
            }
            Att att = new Att(namespace, localName, qName, value);
            atts.addAtt(att);
        }
        elInfo.atts = atts;
    }

    public void setParseLiteralMode() {
        this._parseLiteralMode = true;
        this._xmlLiteralStackHeight = 0;
        this._xmlLiteralPrefixes.clear();
        this._unknownPrefixesInXmlLiteral.clear();
    }

    private URI _createBaseURI(String uriString) {
        int idx;
        if (uriString.length() > 4 && uriString.substring(0, 4).equalsIgnoreCase("jar:") && (idx = uriString.indexOf(33)) != -1) {
            String scheme = uriString.substring(0, idx + 1);
            String path = uriString.substring(idx + 1);
            return new URI(scheme, null, path, null, null);
        }
        URI uri = new URI(uriString);
        uri.normalize();
        return uri;
    }

    private void _appendStartTag(String qName, Attributes attributes) {
        String prefix;
        this._charBuf.append("<" + qName);
        Iterator prefixes = this._newNamespaceMappings.keySet().iterator();
        while (prefixes.hasNext()) {
            String prefix2 = (String)prefixes.next();
            String namespace = (String)this._newNamespaceMappings.get(prefix2);
            this._appendNamespaceDecl(this._charBuf, prefix2, namespace);
        }
        int attCount = attributes.getLength();
        for (int i = 0; i < attCount; ++i) {
            this._appendAttribute(this._charBuf, attributes.getQName(i), attributes.getValue(i));
        }
        this._charBuf.append(">");
        int colonIdx = qName.indexOf(58);
        String string = prefix = colonIdx > 0 ? qName.substring(0, colonIdx) : "";
        if (!this._xmlLiteralPrefixes.contains(prefix) && !this._unknownPrefixesInXmlLiteral.contains(prefix)) {
            this._unknownPrefixesInXmlLiteral.add(prefix);
        }
    }

    private void _appendEndTag(String qName) {
        this._charBuf.append("</" + qName + ">");
    }

    private void _insertUsedContextPrefixes() {
        int unknownPrefixesCount = this._unknownPrefixesInXmlLiteral.size();
        if (unknownPrefixesCount > 0) {
            StringBuffer contextPrefixes = new StringBuffer(1024);
            ElementInfo topElement = this._peekStack();
            for (int i = 0; i < unknownPrefixesCount; ++i) {
                String prefix = (String)this._unknownPrefixesInXmlLiteral.get(i);
                String namespace = topElement.getNamespace(prefix);
                if (namespace == null) continue;
                this._appendNamespaceDecl(contextPrefixes, prefix, namespace);
            }
            int endOfFirstStartTag = 0;
            while (this._charBuf.charAt(endOfFirstStartTag) != '>') {
                ++endOfFirstStartTag;
            }
            this._charBuf.insert(endOfFirstStartTag, contextPrefixes.toString());
        }
        this._unknownPrefixesInXmlLiteral.clear();
    }

    private void _appendNamespaceDecl(StringBuffer sb, String prefix, String namespace) {
        String attName = "xmlns";
        if (!"".equals(prefix)) {
            attName = attName + ":" + prefix;
        }
        this._appendAttribute(sb, attName, namespace);
    }

    private void _appendAttribute(StringBuffer sb, String name, String value) {
        sb.append(" ");
        sb.append(name);
        sb.append("=\"");
        sb.append(XmlUtil.escapeChars((String)value));
        sb.append("\"");
    }

    private ElementInfo _peekStack() {
        ElementInfo result = null;
        if (!this._elInfoStack.empty()) {
            result = (ElementInfo)this._elInfoStack.peek();
        }
        return result;
    }

    private class ElementInfo {
        public String qName;
        public String namespaceURI;
        public String localName;
        public Atts atts;
        public ElementInfo parent;
        private Map _namespaceMap;
        public URI baseURI;
        public String xmlLang;

        public ElementInfo(String qName, String namespaceURI, String localName) {
            this(null, qName, namespaceURI, localName);
        }

        public ElementInfo(ElementInfo parent, String qName, String namespaceURI, String localName) {
            this.parent = parent;
            this.qName = qName;
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            if (parent != null) {
                this.baseURI = parent.baseURI;
                this.xmlLang = parent.xmlLang;
            } else {
                this.baseURI = SAXFilter.this._documentURI;
                this.xmlLang = "";
            }
        }

        public void setBaseURI(String uriString) {
            this.baseURI = this.baseURI.resolve(SAXFilter.this._createBaseURI(uriString));
        }

        public void setNamespaceMappings(Map namespaceMappings) {
            this._namespaceMap = namespaceMappings.isEmpty() ? null : new HashMap(namespaceMappings);
        }

        public String getNamespace(String prefix) {
            String result = null;
            if (this._namespaceMap != null) {
                result = (String)this._namespaceMap.get(prefix);
            }
            if (result == null && this.parent != null) {
                result = this.parent.getNamespace(prefix);
            }
            return result;
        }
    }
}

